/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An analyzed segment for a real-time analysis session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeContactAnalysisSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeContactAnalysisSegment.Builder, RealtimeContactAnalysisSegment> {
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.<Transcript> builder(MarshallingType.SDK_POJO)
            .memberName("Transcript").getter(getter(RealtimeContactAnalysisSegment::transcript))
            .setter(setter(Builder::transcript)).constructor(Transcript::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<Categories> CATEGORIES_FIELD = SdkField.<Categories> builder(MarshallingType.SDK_POJO)
            .memberName("Categories").getter(getter(RealtimeContactAnalysisSegment::categories))
            .setter(setter(Builder::categories)).constructor(Categories::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD,
            CATEGORIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Transcript transcript;

    private final Categories categories;

    private RealtimeContactAnalysisSegment(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The analyzed transcript.
     * </p>
     * 
     * @return The analyzed transcript.
     */
    public final Transcript transcript() {
        return transcript;
    }

    /**
     * <p>
     * The matched category rules.
     * </p>
     * 
     * @return The matched category rules.
     */
    public final Categories categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(categories());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeContactAnalysisSegment)) {
            return false;
        }
        RealtimeContactAnalysisSegment other = (RealtimeContactAnalysisSegment) obj;
        return Objects.equals(transcript(), other.transcript()) && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeContactAnalysisSegment").add("Transcript", transcript()).add("Categories", categories())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeContactAnalysisSegment, T> g) {
        return obj -> g.apply((RealtimeContactAnalysisSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeContactAnalysisSegment> {
        /**
         * <p>
         * The analyzed transcript.
         * </p>
         * 
         * @param transcript
         *        The analyzed transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Transcript transcript);

        /**
         * <p>
         * The analyzed transcript.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transcript.Builder} avoiding the need to
         * create one manually via {@link Transcript#builder()}.
         *
         * When the {@link Consumer} completes, {@link Transcript.Builder#build()} is called immediately and its result
         * is passed to {@link #transcript(Transcript)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link Transcript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(Transcript)
         */
        default Builder transcript(Consumer<Transcript.Builder> transcript) {
            return transcript(Transcript.builder().applyMutation(transcript).build());
        }

        /**
         * <p>
         * The matched category rules.
         * </p>
         * 
         * @param categories
         *        The matched category rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Categories categories);

        /**
         * <p>
         * The matched category rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link Categories.Builder} avoiding the need to
         * create one manually via {@link Categories#builder()}.
         *
         * When the {@link Consumer} completes, {@link Categories.Builder#build()} is called immediately and its result
         * is passed to {@link #categories(Categories)}.
         * 
         * @param categories
         *        a consumer that will call methods on {@link Categories.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(Categories)
         */
        default Builder categories(Consumer<Categories.Builder> categories) {
            return categories(Categories.builder().applyMutation(categories).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Transcript transcript;

        private Categories categories;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeContactAnalysisSegment model) {
            transcript(model.transcript);
            categories(model.categories);
        }

        public final Transcript.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        public final Categories.Builder getCategories() {
            return categories != null ? categories.toBuilder() : null;
        }

        public final void setCategories(Categories.BuilderImpl categories) {
            this.categories = categories != null ? categories.build() : null;
        }

        @Override
        public final Builder categories(Categories categories) {
            this.categories = categories;
            return this;
        }

        @Override
        public RealtimeContactAnalysisSegment build() {
            return new RealtimeContactAnalysisSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
