/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the category rule that was matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoryDetails implements SdkPojo, Serializable, ToCopyableBuilder<CategoryDetails.Builder, CategoryDetails> {
    private static final SdkField<List<PointOfInterest>> POINTS_OF_INTEREST_FIELD = SdkField
            .<List<PointOfInterest>> builder(MarshallingType.LIST)
            .memberName("PointsOfInterest")
            .getter(getter(CategoryDetails::pointsOfInterest))
            .setter(setter(Builder::pointsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PointOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PointOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINTS_OF_INTEREST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PointOfInterest> pointsOfInterest;

    private CategoryDetails(BuilderImpl builder) {
        this.pointsOfInterest = builder.pointsOfInterest;
    }

    /**
     * For responses, this returns true if the service returned a value for the PointsOfInterest property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPointsOfInterest() {
        return pointsOfInterest != null && !(pointsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The section of audio where the category rule was detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPointsOfInterest} method.
     * </p>
     * 
     * @return The section of audio where the category rule was detected.
     */
    public final List<PointOfInterest> pointsOfInterest() {
        return pointsOfInterest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPointsOfInterest() ? pointsOfInterest() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryDetails)) {
            return false;
        }
        CategoryDetails other = (CategoryDetails) obj;
        return hasPointsOfInterest() == other.hasPointsOfInterest()
                && Objects.equals(pointsOfInterest(), other.pointsOfInterest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryDetails").add("PointsOfInterest", hasPointsOfInterest() ? pointsOfInterest() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointsOfInterest":
            return Optional.ofNullable(clazz.cast(pointsOfInterest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryDetails, T> g) {
        return obj -> g.apply((CategoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryDetails> {
        /**
         * <p>
         * The section of audio where the category rule was detected.
         * </p>
         * 
         * @param pointsOfInterest
         *        The section of audio where the category rule was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(Collection<PointOfInterest> pointsOfInterest);

        /**
         * <p>
         * The section of audio where the category rule was detected.
         * </p>
         * 
         * @param pointsOfInterest
         *        The section of audio where the category rule was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(PointOfInterest... pointsOfInterest);

        /**
         * <p>
         * The section of audio where the category rule was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PointOfInterest>.Builder} avoiding the need
         * to create one manually via {@link List<PointOfInterest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PointOfInterest>.Builder#build()} is called immediately and
         * its result is passed to {@link #pointsOfInterest(List<PointOfInterest>)}.
         * 
         * @param pointsOfInterest
         *        a consumer that will call methods on {@link List<PointOfInterest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointsOfInterest(List<PointOfInterest>)
         */
        Builder pointsOfInterest(Consumer<PointOfInterest.Builder>... pointsOfInterest);
    }

    static final class BuilderImpl implements Builder {
        private List<PointOfInterest> pointsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryDetails model) {
            pointsOfInterest(model.pointsOfInterest);
        }

        public final List<PointOfInterest.Builder> getPointsOfInterest() {
            List<PointOfInterest.Builder> result = PointsOfInterestCopier.copyToBuilder(this.pointsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPointsOfInterest(Collection<PointOfInterest.BuilderImpl> pointsOfInterest) {
            this.pointsOfInterest = PointsOfInterestCopier.copyFromBuilder(pointsOfInterest);
        }

        @Override
        @Transient
        public final Builder pointsOfInterest(Collection<PointOfInterest> pointsOfInterest) {
            this.pointsOfInterest = PointsOfInterestCopier.copy(pointsOfInterest);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pointsOfInterest(PointOfInterest... pointsOfInterest) {
            pointsOfInterest(Arrays.asList(pointsOfInterest));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pointsOfInterest(Consumer<PointOfInterest.Builder>... pointsOfInterest) {
            pointsOfInterest(Stream.of(pointsOfInterest).map(c -> PointOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CategoryDetails build() {
            return new CategoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
