/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the post-contact summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostContactSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PostContactSummary.Builder, PostContactSummary> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(PostContactSummary::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PostContactSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(PostContactSummary::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, STATUS_FIELD,
            FAILURE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String status;

    private final String failureCode;

    private PostContactSummary(BuilderImpl builder) {
        this.content = builder.content;
        this.status = builder.status;
        this.failureCode = builder.failureCode;
    }

    /**
     * <p>
     * The content of the summary.
     * </p>
     * 
     * @return The content of the summary.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Whether the summary was successfully COMPLETED or FAILED to be generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PostContactSummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the summary was successfully COMPLETED or FAILED to be generated.
     * @see PostContactSummaryStatus
     */
    public final PostContactSummaryStatus status() {
        return PostContactSummaryStatus.fromValue(status);
    }

    /**
     * <p>
     * Whether the summary was successfully COMPLETED or FAILED to be generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PostContactSummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the summary was successfully COMPLETED or FAILED to be generated.
     * @see PostContactSummaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the summary failed to be generated, one of the following failure codes occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from both the
     * participants in order to generate the summary.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet system
     * safety guidelines.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
     * >language</a> that isn't supported by generative AI-powered post-contact summaries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_ERROR</code>: Internal system error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link PostContactSummaryFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return If the summary failed to be generated, one of the following failure codes occurs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from
     *         both the participants in order to generate the summary.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet
     *         system safety guidelines.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
     *         >language</a> that isn't supported by generative AI-powered post-contact summaries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_ERROR</code>: Internal system error.
     *         </p>
     *         </li>
     * @see PostContactSummaryFailureCode
     */
    public final PostContactSummaryFailureCode failureCode() {
        return PostContactSummaryFailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * If the summary failed to be generated, one of the following failure codes occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from both the
     * participants in order to generate the summary.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet system
     * safety guidelines.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
     * >language</a> that isn't supported by generative AI-powered post-contact summaries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_ERROR</code>: Internal system error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link PostContactSummaryFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return If the summary failed to be generated, one of the following failure codes occurs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from
     *         both the participants in order to generate the summary.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet
     *         system safety guidelines.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
     *         >language</a> that isn't supported by generative AI-powered post-contact summaries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_ERROR</code>: Internal system error.
     *         </p>
     *         </li>
     * @see PostContactSummaryFailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostContactSummary)) {
            return false;
        }
        PostContactSummary other = (PostContactSummary) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostContactSummary").add("Content", content()).add("Status", statusAsString())
                .add("FailureCode", failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostContactSummary, T> g) {
        return obj -> g.apply((PostContactSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostContactSummary> {
        /**
         * <p>
         * The content of the summary.
         * </p>
         * 
         * @param content
         *        The content of the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Whether the summary was successfully COMPLETED or FAILED to be generated.
         * </p>
         * 
         * @param status
         *        Whether the summary was successfully COMPLETED or FAILED to be generated.
         * @see PostContactSummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostContactSummaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the summary was successfully COMPLETED or FAILED to be generated.
         * </p>
         * 
         * @param status
         *        Whether the summary was successfully COMPLETED or FAILED to be generated.
         * @see PostContactSummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostContactSummaryStatus
         */
        Builder status(PostContactSummaryStatus status);

        /**
         * <p>
         * If the summary failed to be generated, one of the following failure codes occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from both
         * the participants in order to generate the summary.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet
         * system safety guidelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
         * >language</a> that isn't supported by generative AI-powered post-contact summaries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_ERROR</code>: Internal system error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureCode
         *        If the summary failed to be generated, one of the following failure codes occurs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from
         *        both the participants in order to generate the summary.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to
         *        meet system safety guidelines.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a
         *        href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
         *        >language</a> that isn't supported by generative AI-powered post-contact summaries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_ERROR</code>: Internal system error.
         *        </p>
         *        </li>
         * @see PostContactSummaryFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostContactSummaryFailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * If the summary failed to be generated, one of the following failure codes occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from both
         * the participants in order to generate the summary.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet
         * system safety guidelines.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
         * >language</a> that isn't supported by generative AI-powered post-contact summaries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_ERROR</code>: Internal system error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureCode
         *        If the summary failed to be generated, one of the following failure codes occurs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from
         *        both the participants in order to generate the summary.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to
         *        meet system safety guidelines.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you're using a <a
         *        href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens"
         *        >language</a> that isn't supported by generative AI-powered post-contact summaries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_ERROR</code>: Internal system error.
         *        </p>
         *        </li>
         * @see PostContactSummaryFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostContactSummaryFailureCode
         */
        Builder failureCode(PostContactSummaryFailureCode failureCode);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String status;

        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(PostContactSummary model) {
            content(model.content);
            status(model.status);
            failureCode(model.failureCode);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PostContactSummaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(PostContactSummaryFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        @Override
        public PostContactSummary build() {
            return new PostContactSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
