/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An analyzed segment for a real-time analysis session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeContactAnalysisSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeContactAnalysisSegment.Builder, RealtimeContactAnalysisSegment> {
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.<Transcript> builder(MarshallingType.SDK_POJO)
            .memberName("Transcript").getter(getter(RealtimeContactAnalysisSegment::transcript))
            .setter(setter(Builder::transcript)).constructor(Transcript::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<Categories> CATEGORIES_FIELD = SdkField.<Categories> builder(MarshallingType.SDK_POJO)
            .memberName("Categories").getter(getter(RealtimeContactAnalysisSegment::categories))
            .setter(setter(Builder::categories)).constructor(Categories::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build()).build();

    private static final SdkField<PostContactSummary> POST_CONTACT_SUMMARY_FIELD = SdkField
            .<PostContactSummary> builder(MarshallingType.SDK_POJO).memberName("PostContactSummary")
            .getter(getter(RealtimeContactAnalysisSegment::postContactSummary)).setter(setter(Builder::postContactSummary))
            .constructor(PostContactSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostContactSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD,
            CATEGORIES_FIELD, POST_CONTACT_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Transcript", TRANSCRIPT_FIELD);
                    put("Categories", CATEGORIES_FIELD);
                    put("PostContactSummary", POST_CONTACT_SUMMARY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Transcript transcript;

    private final Categories categories;

    private final PostContactSummary postContactSummary;

    private RealtimeContactAnalysisSegment(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.categories = builder.categories;
        this.postContactSummary = builder.postContactSummary;
    }

    /**
     * <p>
     * The analyzed transcript.
     * </p>
     * 
     * @return The analyzed transcript.
     */
    public final Transcript transcript() {
        return transcript;
    }

    /**
     * <p>
     * The matched category rules.
     * </p>
     * 
     * @return The matched category rules.
     */
    public final Categories categories() {
        return categories;
    }

    /**
     * <p>
     * Information about the post-contact summary.
     * </p>
     * 
     * @return Information about the post-contact summary.
     */
    public final PostContactSummary postContactSummary() {
        return postContactSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(categories());
        hashCode = 31 * hashCode + Objects.hashCode(postContactSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeContactAnalysisSegment)) {
            return false;
        }
        RealtimeContactAnalysisSegment other = (RealtimeContactAnalysisSegment) obj;
        return Objects.equals(transcript(), other.transcript()) && Objects.equals(categories(), other.categories())
                && Objects.equals(postContactSummary(), other.postContactSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeContactAnalysisSegment").add("Transcript", transcript()).add("Categories", categories())
                .add("PostContactSummary", postContactSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "PostContactSummary":
            return Optional.ofNullable(clazz.cast(postContactSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeContactAnalysisSegment, T> g) {
        return obj -> g.apply((RealtimeContactAnalysisSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeContactAnalysisSegment> {
        /**
         * <p>
         * The analyzed transcript.
         * </p>
         * 
         * @param transcript
         *        The analyzed transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Transcript transcript);

        /**
         * <p>
         * The analyzed transcript.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transcript.Builder} avoiding the need to
         * create one manually via {@link Transcript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Transcript.Builder#build()} is called immediately and its result
         * is passed to {@link #transcript(Transcript)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link Transcript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(Transcript)
         */
        default Builder transcript(Consumer<Transcript.Builder> transcript) {
            return transcript(Transcript.builder().applyMutation(transcript).build());
        }

        /**
         * <p>
         * The matched category rules.
         * </p>
         * 
         * @param categories
         *        The matched category rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Categories categories);

        /**
         * <p>
         * The matched category rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link Categories.Builder} avoiding the need to
         * create one manually via {@link Categories#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Categories.Builder#build()} is called immediately and its result
         * is passed to {@link #categories(Categories)}.
         * 
         * @param categories
         *        a consumer that will call methods on {@link Categories.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(Categories)
         */
        default Builder categories(Consumer<Categories.Builder> categories) {
            return categories(Categories.builder().applyMutation(categories).build());
        }

        /**
         * <p>
         * Information about the post-contact summary.
         * </p>
         * 
         * @param postContactSummary
         *        Information about the post-contact summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postContactSummary(PostContactSummary postContactSummary);

        /**
         * <p>
         * Information about the post-contact summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostContactSummary.Builder} avoiding the
         * need to create one manually via {@link PostContactSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostContactSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #postContactSummary(PostContactSummary)}.
         * 
         * @param postContactSummary
         *        a consumer that will call methods on {@link PostContactSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postContactSummary(PostContactSummary)
         */
        default Builder postContactSummary(Consumer<PostContactSummary.Builder> postContactSummary) {
            return postContactSummary(PostContactSummary.builder().applyMutation(postContactSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Transcript transcript;

        private Categories categories;

        private PostContactSummary postContactSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeContactAnalysisSegment model) {
            transcript(model.transcript);
            categories(model.categories);
            postContactSummary(model.postContactSummary);
        }

        public final Transcript.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        public final Categories.Builder getCategories() {
            return categories != null ? categories.toBuilder() : null;
        }

        public final void setCategories(Categories.BuilderImpl categories) {
            this.categories = categories != null ? categories.build() : null;
        }

        @Override
        public final Builder categories(Categories categories) {
            this.categories = categories;
            return this;
        }

        public final PostContactSummary.Builder getPostContactSummary() {
            return postContactSummary != null ? postContactSummary.toBuilder() : null;
        }

        public final void setPostContactSummary(PostContactSummary.BuilderImpl postContactSummary) {
            this.postContactSummary = postContactSummary != null ? postContactSummary.build() : null;
        }

        @Override
        public final Builder postContactSummary(PostContactSummary postContactSummary) {
            this.postContactSummary = postContactSummary;
            return this;
        }

        @Override
        public RealtimeContactAnalysisSegment build() {
            return new RealtimeContactAnalysisSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
