/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of messages in the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transcript implements SdkPojo, Serializable, ToCopyableBuilder<Transcript.Builder, Transcript> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Transcript::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(Transcript::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(Transcript::participantRole)).setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(Transcript::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffsetMillis").getter(getter(Transcript::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Integer> END_OFFSET_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffsetMillis").getter(getter(Transcript::endOffsetMillis)).setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sentiment").getter(getter(Transcript::sentimentAsString)).setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final SdkField<List<IssueDetected>> ISSUES_DETECTED_FIELD = SdkField
            .<List<IssueDetected>> builder(MarshallingType.LIST)
            .memberName("IssuesDetected")
            .getter(getter(Transcript::issuesDetected))
            .setter(setter(Builder::issuesDetected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuesDetected").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IssueDetected> builder(MarshallingType.SDK_POJO)
                                            .constructor(IssueDetected::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, CONTENT_FIELD, BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD,
            SENTIMENT_FIELD, ISSUES_DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("ParticipantId", PARTICIPANT_ID_FIELD);
                    put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
                    put("Content", CONTENT_FIELD);
                    put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
                    put("EndOffsetMillis", END_OFFSET_MILLIS_FIELD);
                    put("Sentiment", SENTIMENT_FIELD);
                    put("IssuesDetected", ISSUES_DETECTED_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String participantId;

    private final String participantRole;

    private final String content;

    private final Integer beginOffsetMillis;

    private final Integer endOffsetMillis;

    private final String sentiment;

    private final List<IssueDetected> issuesDetected;

    private Transcript(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.content = builder.content;
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.sentiment = builder.sentiment;
        this.issuesDetected = builder.issuesDetected;
    }

    /**
     * <p>
     * The identifier of the transcript.
     * </p>
     * 
     * @return The identifier of the transcript.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the participant. Valid values are CUSTOMER or AGENT.
     * </p>
     * 
     * @return The identifier of the participant. Valid values are CUSTOMER or AGENT.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The role of participant. For example, is it a customer, agent, or system.
     * </p>
     * 
     * @return The role of participant. For example, is it a customer, agent, or system.
     */
    public final String participantRole() {
        return participantRole;
    }

    /**
     * <p>
     * The content of the transcript.
     * </p>
     * 
     * @return The content of the transcript.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The beginning offset in the contact for this transcript.
     * </p>
     * 
     * @return The beginning offset in the contact for this transcript.
     */
    public final Integer beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The end offset in the contact for this transcript.
     * </p>
     * 
     * @return The end offset in the contact for this transcript.
     */
    public final Integer endOffsetMillis() {
        return endOffsetMillis;
    }

    /**
     * <p>
     * The sentiment detected for this piece of transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected for this piece of transcript.
     * @see SentimentValue
     */
    public final SentimentValue sentiment() {
        return SentimentValue.fromValue(sentiment);
    }

    /**
     * <p>
     * The sentiment detected for this piece of transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected for this piece of transcript.
     * @see SentimentValue
     */
    public final String sentimentAsString() {
        return sentiment;
    }

    /**
     * For responses, this returns true if the service returned a value for the IssuesDetected property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIssuesDetected() {
        return issuesDetected != null && !(issuesDetected instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of positions where issues were detected on the transcript.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssuesDetected} method.
     * </p>
     * 
     * @return List of positions where issues were detected on the transcript.
     */
    public final List<IssueDetected> issuesDetected() {
        return issuesDetected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRole());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIssuesDetected() ? issuesDetected() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantRole(), other.participantRole()) && Objects.equals(content(), other.content())
                && Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis())
                && Objects.equals(sentimentAsString(), other.sentimentAsString())
                && hasIssuesDetected() == other.hasIssuesDetected() && Objects.equals(issuesDetected(), other.issuesDetected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Transcript").add("Id", id()).add("ParticipantId", participantId())
                .add("ParticipantRole", participantRole()).add("Content", content())
                .add("BeginOffsetMillis", beginOffsetMillis()).add("EndOffsetMillis", endOffsetMillis())
                .add("Sentiment", sentimentAsString()).add("IssuesDetected", hasIssuesDetected() ? issuesDetected() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRole()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        case "IssuesDetected":
            return Optional.ofNullable(clazz.cast(issuesDetected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transcript> {
        /**
         * <p>
         * The identifier of the transcript.
         * </p>
         * 
         * @param id
         *        The identifier of the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the participant. Valid values are CUSTOMER or AGENT.
         * </p>
         * 
         * @param participantId
         *        The identifier of the participant. Valid values are CUSTOMER or AGENT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The role of participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of participant. For example, is it a customer, agent, or system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The content of the transcript.
         * </p>
         * 
         * @param content
         *        The content of the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The beginning offset in the contact for this transcript.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The beginning offset in the contact for this transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Integer beginOffsetMillis);

        /**
         * <p>
         * The end offset in the contact for this transcript.
         * </p>
         * 
         * @param endOffsetMillis
         *        The end offset in the contact for this transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Integer endOffsetMillis);

        /**
         * <p>
         * The sentiment detected for this piece of transcript.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected for this piece of transcript.
         * @see SentimentValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentValue
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * The sentiment detected for this piece of transcript.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected for this piece of transcript.
         * @see SentimentValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentValue
         */
        Builder sentiment(SentimentValue sentiment);

        /**
         * <p>
         * List of positions where issues were detected on the transcript.
         * </p>
         * 
         * @param issuesDetected
         *        List of positions where issues were detected on the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(Collection<IssueDetected> issuesDetected);

        /**
         * <p>
         * List of positions where issues were detected on the transcript.
         * </p>
         * 
         * @param issuesDetected
         *        List of positions where issues were detected on the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(IssueDetected... issuesDetected);

        /**
         * <p>
         * List of positions where issues were detected on the transcript.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcontactlens.model.IssueDetected.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcontactlens.model.IssueDetected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcontactlens.model.IssueDetected.Builder#build()} is called
         * immediately and its result is passed to {@link #issuesDetected(List<IssueDetected>)}.
         * 
         * @param issuesDetected
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcontactlens.model.IssueDetected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuesDetected(java.util.Collection<IssueDetected>)
         */
        Builder issuesDetected(Consumer<IssueDetected.Builder>... issuesDetected);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String participantId;

        private String participantRole;

        private String content;

        private Integer beginOffsetMillis;

        private Integer endOffsetMillis;

        private String sentiment;

        private List<IssueDetected> issuesDetected = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            id(model.id);
            participantId(model.participantId);
            participantRole(model.participantRole);
            content(model.content);
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
            sentiment(model.sentiment);
            issuesDetected(model.issuesDetected);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Integer getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Integer getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getSentiment() {
            return sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentValue sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final List<IssueDetected.Builder> getIssuesDetected() {
            List<IssueDetected.Builder> result = IssuesDetectedCopier.copyToBuilder(this.issuesDetected);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssuesDetected(Collection<IssueDetected.BuilderImpl> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copyFromBuilder(issuesDetected);
        }

        @Override
        public final Builder issuesDetected(Collection<IssueDetected> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copy(issuesDetected);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(IssueDetected... issuesDetected) {
            issuesDetected(Arrays.asList(issuesDetected));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(Consumer<IssueDetected.Builder>... issuesDetected) {
            issuesDetected(Stream.of(issuesDetected).map(c -> IssueDetected.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Transcript build() {
            return new Transcript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
