/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantResponse;
import software.amazon.awssdk.services.connectparticipant.model.Item;
import software.amazon.awssdk.services.connectparticipant.model.TranscriptCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTranscriptResponse
extends ConnectParticipantResponse
implements ToCopyableBuilder<Builder, GetTranscriptResponse> {
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTranscriptResponse.getter(GetTranscriptResponse::initialContactId)).setter(GetTranscriptResponse.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<List<Item>> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetTranscriptResponse.getter(GetTranscriptResponse::transcript)).setter(GetTranscriptResponse.setter(Builder::transcript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Item::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetTranscriptResponse.getter(GetTranscriptResponse::nextToken)).setter(GetTranscriptResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CONTACT_ID_FIELD, TRANSCRIPT_FIELD, NEXT_TOKEN_FIELD));
    private final String initialContactId;
    private final List<Item> transcript;
    private final String nextToken;

    private GetTranscriptResponse(BuilderImpl builder) {
        super(builder);
        this.initialContactId = builder.initialContactId;
        this.transcript = builder.transcript;
        this.nextToken = builder.nextToken;
    }

    public String initialContactId() {
        return this.initialContactId;
    }

    public List<Item> transcript() {
        return this.transcript;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTranscriptResponse)) {
            return false;
        }
        GetTranscriptResponse other = (GetTranscriptResponse)((Object)obj);
        return Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.transcript(), other.transcript()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTranscriptResponse").add("InitialContactId", (Object)this.initialContactId()).add("Transcript", this.transcript()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTranscriptResponse, T> g) {
        return obj -> g.apply((GetTranscriptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantResponse.BuilderImpl
    implements Builder {
        private String initialContactId;
        private List<Item> transcript = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTranscriptResponse model) {
            super(model);
            this.initialContactId(model.initialContactId);
            this.transcript(model.transcript);
            this.nextToken(model.nextToken);
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        public final Collection<Item.Builder> getTranscript() {
            return this.transcript != null ? (Collection)this.transcript.stream().map(Item::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transcript(Collection<Item> transcript) {
            this.transcript = TranscriptCopier.copy(transcript);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcript(Item ... transcript) {
            this.transcript(Arrays.asList(transcript));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcript(Consumer<Item.Builder> ... transcript) {
            this.transcript(Stream.of(transcript).map(c -> (Item)((Item.Builder)Item.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTranscript(Collection<Item.BuilderImpl> transcript) {
            this.transcript = TranscriptCopier.copyFromBuilder(transcript);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTranscriptResponse build() {
            return new GetTranscriptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTranscriptResponse> {
        public Builder initialContactId(String var1);

        public Builder transcript(Collection<Item> var1);

        public Builder transcript(Item ... var1);

        public Builder transcript(Consumer<Item.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

