/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParticipantConnectionRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<CreateParticipantConnectionRequest.Builder, CreateParticipantConnectionRequest> {
    private static final SdkField<List<String>> TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateParticipantConnectionRequest::typeAsStrings))
            .setter(setter(Builder::typeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateParticipantConnectionRequest::participantToken)).setter(setter(Builder::participantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PARTICIPANT_TOKEN_FIELD));

    private final List<String> type;

    private final String participantToken;

    private CreateParticipantConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.participantToken = builder.participantToken;
    }

    /**
     * <p>
     * Type of connection information required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Type of connection information required.
     */
    public List<ConnectionType> type() {
        return ConnectionTypeListCopier.copyStringToEnum(type);
    }

    /**
     * Returns true if the Type property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Type of connection information required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Type of connection information required.
     */
    public List<String> typeAsStrings() {
        return type;
    }

    /**
     * <p>
     * Participant Token as obtained from <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContactResponse.html"
     * >StartChatContact</a> API response.
     * </p>
     * 
     * @return Participant Token as obtained from <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContactResponse.html"
     *         >StartChatContact</a> API response.
     */
    public String participantToken() {
        return participantToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(participantToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantConnectionRequest)) {
            return false;
        }
        CreateParticipantConnectionRequest other = (CreateParticipantConnectionRequest) obj;
        return Objects.equals(typeAsStrings(), other.typeAsStrings())
                && Objects.equals(participantToken(), other.participantToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateParticipantConnectionRequest").add("Type", typeAsStrings())
                .add("ParticipantToken", participantToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsStrings()));
        case "ParticipantToken":
            return Optional.ofNullable(clazz.cast(participantToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantConnectionRequest, T> g) {
        return obj -> g.apply((CreateParticipantConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateParticipantConnectionRequest> {
        /**
         * <p>
         * Type of connection information required.
         * </p>
         * 
         * @param type
         *        Type of connection information required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(Collection<String> type);

        /**
         * <p>
         * Type of connection information required.
         * </p>
         * 
         * @param type
         *        Type of connection information required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(String... type);

        /**
         * <p>
         * Type of connection information required.
         * </p>
         * 
         * @param type
         *        Type of connection information required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<ConnectionType> type);

        /**
         * <p>
         * Type of connection information required.
         * </p>
         * 
         * @param type
         *        Type of connection information required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ConnectionType... type);

        /**
         * <p>
         * Participant Token as obtained from <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContactResponse.html"
         * >StartChatContact</a> API response.
         * </p>
         * 
         * @param participantToken
         *        Participant Token as obtained from <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContactResponse.html"
         *        >StartChatContact</a> API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantToken(String participantToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private List<String> type = DefaultSdkAutoConstructList.getInstance();

        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantConnectionRequest model) {
            super(model);
            typeWithStrings(model.type);
            participantToken(model.participantToken);
        }

        public final Collection<String> getTypeAsStrings() {
            return type;
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = ConnectionTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String... type) {
            typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<ConnectionType> type) {
            this.type = ConnectionTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(ConnectionType... type) {
            type(Arrays.asList(type));
            return this;
        }

        public final void setTypeWithStrings(Collection<String> type) {
            this.type = ConnectionTypeListCopier.copy(type);
        }

        public final String getParticipantToken() {
            return participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateParticipantConnectionRequest build() {
            return new CreateParticipantConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
