/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connection credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionCredentials.Builder, ConnectionCredentials> {
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionCredentials::connectionToken)).setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionToken").build()).build();

    private static final SdkField<String> EXPIRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionCredentials::expiry)).setter(setter(Builder::expiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TOKEN_FIELD,
            EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionToken;

    private final String expiry;

    private ConnectionCredentials(BuilderImpl builder) {
        this.connectionToken = builder.connectionToken;
        this.expiry = builder.expiry;
    }

    /**
     * <p>
     * The connection token.
     * </p>
     * 
     * @return The connection token.
     */
    public String connectionToken() {
        return connectionToken;
    }

    /**
     * <p>
     * The expiration of the token.
     * </p>
     * <p>
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The expiration of the token.</p>
     *         <p>
     *         It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public String expiry() {
        return expiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiry());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionCredentials)) {
            return false;
        }
        ConnectionCredentials other = (ConnectionCredentials) obj;
        return Objects.equals(connectionToken(), other.connectionToken()) && Objects.equals(expiry(), other.expiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionCredentials").add("ConnectionToken", connectionToken()).add("Expiry", expiry())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        case "Expiry":
            return Optional.ofNullable(clazz.cast(expiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionCredentials, T> g) {
        return obj -> g.apply((ConnectionCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionCredentials> {
        /**
         * <p>
         * The connection token.
         * </p>
         * 
         * @param connectionToken
         *        The connection token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        /**
         * <p>
         * The expiration of the token.
         * </p>
         * <p>
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param expiry
         *        The expiration of the token.</p>
         *        <p>
         *        It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(String expiry);
    }

    static final class BuilderImpl implements Builder {
        private String connectionToken;

        private String expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionCredentials model) {
            connectionToken(model.connectionToken);
            expiry(model.expiry);
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        public final String getExpiry() {
            return expiry;
        }

        @Override
        public final Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        public final void setExpiry(String expiry) {
            this.expiry = expiry;
        }

        @Override
        public ConnectionCredentials build() {
            return new ConnectionCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
