/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConnectionType {
    WEBSOCKET("WEBSOCKET"),
    CONNECTION_CREDENTIALS("CONNECTION_CREDENTIALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionType> knownValues() {
        return Stream.of(ConnectionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

