/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChatItemType {
    MESSAGE("MESSAGE"),
    EVENT("EVENT"),
    CONNECTION_ACK("CONNECTION_ACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ChatItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChatItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ChatItemType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChatItemType> knownValues() {
        return Stream.of(ChatItemType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

