/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantResponse;
import software.amazon.awssdk.services.connectparticipant.model.ConnectionCredentials;
import software.amazon.awssdk.services.connectparticipant.model.Websocket;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateParticipantConnectionResponse
extends ConnectParticipantResponse
implements ToCopyableBuilder<Builder, CreateParticipantConnectionResponse> {
    private static final SdkField<Websocket> WEBSOCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Websocket").getter(CreateParticipantConnectionResponse.getter(CreateParticipantConnectionResponse::websocket)).setter(CreateParticipantConnectionResponse.setter(Builder::websocket)).constructor(Websocket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Websocket").build()}).build();
    private static final SdkField<ConnectionCredentials> CONNECTION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionCredentials").getter(CreateParticipantConnectionResponse.getter(CreateParticipantConnectionResponse::connectionCredentials)).setter(CreateParticipantConnectionResponse.setter(Builder::connectionCredentials)).constructor(ConnectionCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionCredentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSOCKET_FIELD, CONNECTION_CREDENTIALS_FIELD));
    private final Websocket websocket;
    private final ConnectionCredentials connectionCredentials;

    private CreateParticipantConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.websocket = builder.websocket;
        this.connectionCredentials = builder.connectionCredentials;
    }

    public Websocket websocket() {
        return this.websocket;
    }

    public ConnectionCredentials connectionCredentials() {
        return this.connectionCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.websocket());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionCredentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantConnectionResponse)) {
            return false;
        }
        CreateParticipantConnectionResponse other = (CreateParticipantConnectionResponse)((Object)obj);
        return Objects.equals(this.websocket(), other.websocket()) && Objects.equals(this.connectionCredentials(), other.connectionCredentials());
    }

    public String toString() {
        return ToString.builder((String)"CreateParticipantConnectionResponse").add("Websocket", (Object)this.websocket()).add("ConnectionCredentials", (Object)this.connectionCredentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Websocket": {
                return Optional.ofNullable(clazz.cast(this.websocket()));
            }
            case "ConnectionCredentials": {
                return Optional.ofNullable(clazz.cast(this.connectionCredentials()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantConnectionResponse, T> g) {
        return obj -> g.apply((CreateParticipantConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantResponse.BuilderImpl
    implements Builder {
        private Websocket websocket;
        private ConnectionCredentials connectionCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantConnectionResponse model) {
            super(model);
            this.websocket(model.websocket);
            this.connectionCredentials(model.connectionCredentials);
        }

        public final Websocket.Builder getWebsocket() {
            return this.websocket != null ? this.websocket.toBuilder() : null;
        }

        @Override
        public final Builder websocket(Websocket websocket) {
            this.websocket = websocket;
            return this;
        }

        public final void setWebsocket(Websocket.BuilderImpl websocket) {
            this.websocket = websocket != null ? websocket.build() : null;
        }

        public final ConnectionCredentials.Builder getConnectionCredentials() {
            return this.connectionCredentials != null ? this.connectionCredentials.toBuilder() : null;
        }

        @Override
        public final Builder connectionCredentials(ConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            return this;
        }

        public final void setConnectionCredentials(ConnectionCredentials.BuilderImpl connectionCredentials) {
            this.connectionCredentials = connectionCredentials != null ? connectionCredentials.build() : null;
        }

        @Override
        public CreateParticipantConnectionResponse build() {
            return new CreateParticipantConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateParticipantConnectionResponse> {
        public Builder websocket(Websocket var1);

        default public Builder websocket(Consumer<Websocket.Builder> websocket) {
            return this.websocket((Websocket)((Websocket.Builder)Websocket.builder().applyMutation(websocket)).build());
        }

        public Builder connectionCredentials(ConnectionCredentials var1);

        default public Builder connectionCredentials(Consumer<ConnectionCredentials.Builder> connectionCredentials) {
            return this.connectionCredentials((ConnectionCredentials)((ConnectionCredentials.Builder)ConnectionCredentials.builder().applyMutation(connectionCredentials)).build());
        }
    }
}

