/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMessageRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, SendMessageRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(SendMessageRequest.getter(SendMessageRequest::contentType)).setter(SendMessageRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(SendMessageRequest.getter(SendMessageRequest::content)).setter(SendMessageRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(SendMessageRequest.getter(SendMessageRequest::clientToken)).setter(SendMessageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(SendMessageRequest.getter(SendMessageRequest::connectionToken)).setter(SendMessageRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, CONTENT_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));
    private final String contentType;
    private final String content;
    private final String clientToken;
    private final String connectionToken;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    public String contentType() {
        return this.contentType;
    }

    public String content() {
        return this.content;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String connectionToken() {
        return this.connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.connectionToken(), other.connectionToken());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageRequest").add("ContentType", (Object)this.contentType()).add("Content", (Object)this.content()).add("ClientToken", (Object)this.clientToken()).add("ConnectionToken", (Object)this.connectionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private String content;
        private String clientToken;
        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.content(model.content);
            this.clientToken(model.clientToken);
            this.connectionToken(model.connectionToken);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMessageRequest> {
        public Builder contentType(String var1);

        public Builder content(String var1);

        public Builder clientToken(String var1);

        public Builder connectionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

