/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.services.connectparticipant.model.ScanDirection;
import software.amazon.awssdk.services.connectparticipant.model.SortKey;
import software.amazon.awssdk.services.connectparticipant.model.StartPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTranscriptRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, GetTranscriptRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(GetTranscriptRequest.getter(GetTranscriptRequest::contactId)).setter(GetTranscriptRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetTranscriptRequest.getter(GetTranscriptRequest::maxResults)).setter(GetTranscriptRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTranscriptRequest.getter(GetTranscriptRequest::nextToken)).setter(GetTranscriptRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SCAN_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanDirection").getter(GetTranscriptRequest.getter(GetTranscriptRequest::scanDirectionAsString)).setter(GetTranscriptRequest.setter(Builder::scanDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanDirection").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(GetTranscriptRequest.getter(GetTranscriptRequest::sortOrderAsString)).setter(GetTranscriptRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<StartPosition> START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartPosition").getter(GetTranscriptRequest.getter(GetTranscriptRequest::startPosition)).setter(GetTranscriptRequest.setter(Builder::startPosition)).constructor(StartPosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(GetTranscriptRequest.getter(GetTranscriptRequest::connectionToken)).setter(GetTranscriptRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCAN_DIRECTION_FIELD, SORT_ORDER_FIELD, START_POSITION_FIELD, CONNECTION_TOKEN_FIELD));
    private final String contactId;
    private final Integer maxResults;
    private final String nextToken;
    private final String scanDirection;
    private final String sortOrder;
    private final StartPosition startPosition;
    private final String connectionToken;

    private GetTranscriptRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scanDirection = builder.scanDirection;
        this.sortOrder = builder.sortOrder;
        this.startPosition = builder.startPosition;
        this.connectionToken = builder.connectionToken;
    }

    public String contactId() {
        return this.contactId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ScanDirection scanDirection() {
        return ScanDirection.fromValue(this.scanDirection);
    }

    public String scanDirectionAsString() {
        return this.scanDirection;
    }

    public SortKey sortOrder() {
        return SortKey.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public StartPosition startPosition() {
        return this.startPosition;
    }

    public String connectionToken() {
        return this.connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTranscriptRequest)) {
            return false;
        }
        GetTranscriptRequest other = (GetTranscriptRequest)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scanDirectionAsString(), other.scanDirectionAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.startPosition(), other.startPosition()) && Objects.equals(this.connectionToken(), other.connectionToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTranscriptRequest").add("ContactId", (Object)this.contactId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ScanDirection", (Object)this.scanDirectionAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("StartPosition", (Object)this.startPosition()).add("ConnectionToken", (Object)this.connectionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScanDirection": {
                return Optional.ofNullable(clazz.cast(this.scanDirectionAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "StartPosition": {
                return Optional.ofNullable(clazz.cast(this.startPosition()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTranscriptRequest, T> g) {
        return obj -> g.apply((GetTranscriptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private String contactId;
        private Integer maxResults;
        private String nextToken;
        private String scanDirection;
        private String sortOrder;
        private StartPosition startPosition;
        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTranscriptRequest model) {
            super(model);
            this.contactId(model.contactId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.scanDirection(model.scanDirection);
            this.sortOrder(model.sortOrder);
            this.startPosition(model.startPosition);
            this.connectionToken(model.connectionToken);
        }

        public final String getContactId() {
            return this.contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getScanDirection() {
            return this.scanDirection;
        }

        @Override
        public final Builder scanDirection(String scanDirection) {
            this.scanDirection = scanDirection;
            return this;
        }

        @Override
        public final Builder scanDirection(ScanDirection scanDirection) {
            this.scanDirection(scanDirection == null ? null : scanDirection.toString());
            return this;
        }

        public final void setScanDirection(String scanDirection) {
            this.scanDirection = scanDirection;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortKey sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final StartPosition.Builder getStartPosition() {
            return this.startPosition != null ? this.startPosition.toBuilder() : null;
        }

        @Override
        public final Builder startPosition(StartPosition startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final void setStartPosition(StartPosition.BuilderImpl startPosition) {
            this.startPosition = startPosition != null ? startPosition.build() : null;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTranscriptRequest build() {
            return new GetTranscriptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTranscriptRequest> {
        public Builder contactId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder scanDirection(String var1);

        public Builder scanDirection(ScanDirection var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortKey var1);

        public Builder startPosition(StartPosition var1);

        default public Builder startPosition(Consumer<StartPosition.Builder> startPosition) {
            return this.startPosition((StartPosition)((StartPosition.Builder)StartPosition.builder().applyMutation(startPosition)).build());
        }

        public Builder connectionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

