/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ChatItemType;
import software.amazon.awssdk.services.connectparticipant.model.ParticipantRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Item
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Item> {
    private static final SdkField<String> ABSOLUTE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbsoluteTime").getter(Item.getter(Item::absoluteTime)).setter(Item.setter(Builder::absoluteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTime").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(Item.getter(Item::content)).setter(Item.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(Item.getter(Item::contentType)).setter(Item.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Item.getter(Item::id)).setter(Item.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Item.getter(Item::typeAsString)).setter(Item.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(Item.getter(Item::participantId)).setter(Item.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Item.getter(Item::displayName)).setter(Item.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(Item.getter(Item::participantRoleAsString)).setter(Item.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABSOLUTE_TIME_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, ID_FIELD, TYPE_FIELD, PARTICIPANT_ID_FIELD, DISPLAY_NAME_FIELD, PARTICIPANT_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String absoluteTime;
    private final String content;
    private final String contentType;
    private final String id;
    private final String type;
    private final String participantId;
    private final String displayName;
    private final String participantRole;

    private Item(BuilderImpl builder) {
        this.absoluteTime = builder.absoluteTime;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.id = builder.id;
        this.type = builder.type;
        this.participantId = builder.participantId;
        this.displayName = builder.displayName;
        this.participantRole = builder.participantRole;
    }

    public final String absoluteTime() {
        return this.absoluteTime;
    }

    public final String content() {
        return this.content;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String id() {
        return this.id;
    }

    public final ChatItemType type() {
        return ChatItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        return Objects.equals(this.absoluteTime(), other.absoluteTime()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Item").add("AbsoluteTime", (Object)this.absoluteTime()).add("Content", (Object)this.content()).add("ContentType", (Object)this.contentType()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("ParticipantId", (Object)this.participantId()).add("DisplayName", (Object)this.displayName()).add("ParticipantRole", (Object)this.participantRoleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AbsoluteTime": {
                return Optional.ofNullable(clazz.cast(this.absoluteTime()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String absoluteTime;
        private String content;
        private String contentType;
        private String id;
        private String type;
        private String participantId;
        private String displayName;
        private String participantRole;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            this.absoluteTime(model.absoluteTime);
            this.content(model.content);
            this.contentType(model.contentType);
            this.id(model.id);
            this.type(model.type);
            this.participantId(model.participantId);
            this.displayName(model.displayName);
            this.participantRole(model.participantRole);
        }

        public final String getAbsoluteTime() {
            return this.absoluteTime;
        }

        @Override
        public final Builder absoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
            return this;
        }

        public final void setAbsoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChatItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        public Item build() {
            return new Item(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Item> {
        public Builder absoluteTime(String var1);

        public Builder content(String var1);

        public Builder contentType(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ChatItemType var1);

        public Builder participantId(String var1);

        public Builder displayName(String var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);
    }
}

