/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTranscriptResponse extends ConnectParticipantResponse implements
        ToCopyableBuilder<GetTranscriptResponse.Builder, GetTranscriptResponse> {
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(GetTranscriptResponse::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<List<Item>> TRANSCRIPT_FIELD = SdkField
            .<List<Item>> builder(MarshallingType.LIST)
            .memberName("Transcript")
            .getter(getter(GetTranscriptResponse::transcript))
            .setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Item> builder(MarshallingType.SDK_POJO)
                                            .constructor(Item::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTranscriptResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CONTACT_ID_FIELD,
            TRANSCRIPT_FIELD, NEXT_TOKEN_FIELD));

    private final String initialContactId;

    private final List<Item> transcript;

    private final String nextToken;

    private GetTranscriptResponse(BuilderImpl builder) {
        super(builder);
        this.initialContactId = builder.initialContactId;
        this.transcript = builder.transcript;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The initial contact ID for the contact.
     * </p>
     * 
     * @return The initial contact ID for the contact.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * Returns true if the Transcript property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTranscript() {
        return transcript != null && !(transcript instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of messages in the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTranscript()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of messages in the session.
     */
    public final List<Item> transcript() {
        return transcript;
    }

    /**
     * <p>
     * The pagination token. Use the value returned previously in the next subsequent request to retrieve the next set
     * of results.
     * </p>
     * 
     * @return The pagination token. Use the value returned previously in the next subsequent request to retrieve the
     *         next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTranscript() ? transcript() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTranscriptResponse)) {
            return false;
        }
        GetTranscriptResponse other = (GetTranscriptResponse) obj;
        return Objects.equals(initialContactId(), other.initialContactId()) && hasTranscript() == other.hasTranscript()
                && Objects.equals(transcript(), other.transcript()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTranscriptResponse").add("InitialContactId", initialContactId())
                .add("Transcript", hasTranscript() ? transcript() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTranscriptResponse, T> g) {
        return obj -> g.apply((GetTranscriptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTranscriptResponse> {
        /**
         * <p>
         * The initial contact ID for the contact.
         * </p>
         * 
         * @param initialContactId
         *        The initial contact ID for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * The list of messages in the session.
         * </p>
         * 
         * @param transcript
         *        The list of messages in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Collection<Item> transcript);

        /**
         * <p>
         * The list of messages in the session.
         * </p>
         * 
         * @param transcript
         *        The list of messages in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Item... transcript);

        /**
         * <p>
         * The list of messages in the session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Item>.Builder} avoiding the need to create
         * one manually via {@link List<Item>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Item>.Builder#build()} is called immediately and its result
         * is passed to {@link #transcript(List<Item>)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link List<Item>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(List<Item>)
         */
        Builder transcript(Consumer<Item.Builder>... transcript);

        /**
         * <p>
         * The pagination token. Use the value returned previously in the next subsequent request to retrieve the next
         * set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token. Use the value returned previously in the next subsequent request to retrieve the
         *        next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectParticipantResponse.BuilderImpl implements Builder {
        private String initialContactId;

        private List<Item> transcript = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTranscriptResponse model) {
            super(model);
            initialContactId(model.initialContactId);
            transcript(model.transcript);
            nextToken(model.nextToken);
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        public final Collection<Item.Builder> getTranscript() {
            if (transcript instanceof SdkAutoConstructList) {
                return null;
            }
            return transcript != null ? transcript.stream().map(Item::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transcript(Collection<Item> transcript) {
            this.transcript = TranscriptCopier.copy(transcript);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcript(Item... transcript) {
            transcript(Arrays.asList(transcript));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcript(Consumer<Item.Builder>... transcript) {
            transcript(Stream.of(transcript).map(c -> Item.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTranscript(Collection<Item.BuilderImpl> transcript) {
            this.transcript = TranscriptCopier.copyFromBuilder(transcript);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTranscriptResponse build() {
            return new GetTranscriptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
