/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageResponse extends ConnectParticipantResponse implements
        ToCopyableBuilder<SendMessageResponse.Builder, SendMessageResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SendMessageResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ABSOLUTE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbsoluteTime").getter(getter(SendMessageResponse::absoluteTime)).setter(setter(Builder::absoluteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ID_FIELD, ABSOLUTE_TIME_FIELD));

    private final String id;

    private final String absoluteTime;

    private SendMessageResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.absoluteTime = builder.absoluteTime;
    }

    /**
     * <p>
     * The ID of the message.
     * </p>
     * 
     * @return The ID of the message.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time when the message was sent.
     * </p>
     * <p>
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The time when the message was sent.</p>
     *         <p>
     *         It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public final String absoluteTime() {
        return absoluteTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(absoluteTime(), other.absoluteTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageResponse").add("Id", id()).add("AbsoluteTime", absoluteTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AbsoluteTime":
            return Optional.ofNullable(clazz.cast(absoluteTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageResponse, T> g) {
        return obj -> g.apply((SendMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageResponse> {
        /**
         * <p>
         * The ID of the message.
         * </p>
         * 
         * @param id
         *        The ID of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time when the message was sent.
         * </p>
         * <p>
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param absoluteTime
         *        The time when the message was sent.</p>
         *        <p>
         *        It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTime(String absoluteTime);
    }

    static final class BuilderImpl extends ConnectParticipantResponse.BuilderImpl implements Builder {
        private String id;

        private String absoluteTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            super(model);
            id(model.id);
            absoluteTime(model.absoluteTime);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAbsoluteTime() {
            return absoluteTime;
        }

        @Override
        public final Builder absoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
            return this;
        }

        public final void setAbsoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
        }

        @Override
        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
