/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The websocket for the participant's connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Websocket implements SdkPojo, Serializable, ToCopyableBuilder<Websocket.Builder, Websocket> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(Websocket::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> CONNECTION_EXPIRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionExpiry").getter(getter(Websocket::connectionExpiry)).setter(setter(Builder::connectionExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            CONNECTION_EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String connectionExpiry;

    private Websocket(BuilderImpl builder) {
        this.url = builder.url;
        this.connectionExpiry = builder.connectionExpiry;
    }

    /**
     * <p>
     * The URL of the websocket.
     * </p>
     * 
     * @return The URL of the websocket.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The URL expiration timestamp in ISO date format.
     * </p>
     * <p>
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The URL expiration timestamp in ISO date format.</p>
     *         <p>
     *         It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public final String connectionExpiry() {
        return connectionExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(connectionExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Websocket)) {
            return false;
        }
        Websocket other = (Websocket) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(connectionExpiry(), other.connectionExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Websocket").add("Url", url()).add("ConnectionExpiry", connectionExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ConnectionExpiry":
            return Optional.ofNullable(clazz.cast(connectionExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Websocket, T> g) {
        return obj -> g.apply((Websocket) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Websocket> {
        /**
         * <p>
         * The URL of the websocket.
         * </p>
         * 
         * @param url
         *        The URL of the websocket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The URL expiration timestamp in ISO date format.
         * </p>
         * <p>
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param connectionExpiry
         *        The URL expiration timestamp in ISO date format.</p>
         *        <p>
         *        It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionExpiry(String connectionExpiry);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String connectionExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(Websocket model) {
            url(model.url);
            connectionExpiry(model.connectionExpiry);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getConnectionExpiry() {
            return connectionExpiry;
        }

        @Override
        public final Builder connectionExpiry(String connectionExpiry) {
            this.connectionExpiry = connectionExpiry;
            return this;
        }

        public final void setConnectionExpiry(String connectionExpiry) {
            this.connectionExpiry = connectionExpiry;
        }

        @Override
        public Websocket build() {
            return new Websocket(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
