/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAttachmentUploadRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<StartAttachmentUploadRequest.Builder, StartAttachmentUploadRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(StartAttachmentUploadRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<Long> ATTACHMENT_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AttachmentSizeInBytes").getter(getter(StartAttachmentUploadRequest::attachmentSizeInBytes))
            .setter(setter(Builder::attachmentSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSizeInBytes").build())
            .build();

    private static final SdkField<String> ATTACHMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentName").getter(getter(StartAttachmentUploadRequest::attachmentName))
            .setter(setter(Builder::attachmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartAttachmentUploadRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionToken").getter(getter(StartAttachmentUploadRequest::connectionToken))
            .setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            ATTACHMENT_SIZE_IN_BYTES_FIELD, ATTACHMENT_NAME_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));

    private final String contentType;

    private final Long attachmentSizeInBytes;

    private final String attachmentName;

    private final String clientToken;

    private final String connectionToken;

    private StartAttachmentUploadRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.attachmentSizeInBytes = builder.attachmentSizeInBytes;
        this.attachmentName = builder.attachmentName;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * <p>
     * Describes the MIME file type of the attachment. For a list of supported file types, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
     * >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return Describes the MIME file type of the attachment. For a list of supported file types, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
     *         >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The size of the attachment in bytes.
     * </p>
     * 
     * @return The size of the attachment in bytes.
     */
    public final Long attachmentSizeInBytes() {
        return attachmentSizeInBytes;
    }

    /**
     * <p>
     * A case-sensitive name of the attachment being uploaded.
     * </p>
     * 
     * @return A case-sensitive name of the attachment being uploaded.
     */
    public final String attachmentName() {
        return attachmentName;
    }

    /**
     * <p>
     * A unique case sensitive identifier to support idempotency of request.
     * </p>
     * 
     * @return A unique case sensitive identifier to support idempotency of request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The authentication token associated with the participant's connection.
     * </p>
     * 
     * @return The authentication token associated with the participant's connection.
     */
    public final String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachmentUploadRequest)) {
            return false;
        }
        StartAttachmentUploadRequest other = (StartAttachmentUploadRequest) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(attachmentSizeInBytes(), other.attachmentSizeInBytes())
                && Objects.equals(attachmentName(), other.attachmentName()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAttachmentUploadRequest").add("ContentType", contentType())
                .add("AttachmentSizeInBytes", attachmentSizeInBytes()).add("AttachmentName", attachmentName())
                .add("ClientToken", clientToken()).add("ConnectionToken", connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "AttachmentSizeInBytes":
            return Optional.ofNullable(clazz.cast(attachmentSizeInBytes()));
        case "AttachmentName":
            return Optional.ofNullable(clazz.cast(attachmentName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAttachmentUploadRequest, T> g) {
        return obj -> g.apply((StartAttachmentUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAttachmentUploadRequest> {
        /**
         * <p>
         * Describes the MIME file type of the attachment. For a list of supported file types, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
         * >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param contentType
         *        Describes the MIME file type of the attachment. For a list of supported file types, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
         *        >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The size of the attachment in bytes.
         * </p>
         * 
         * @param attachmentSizeInBytes
         *        The size of the attachment in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSizeInBytes(Long attachmentSizeInBytes);

        /**
         * <p>
         * A case-sensitive name of the attachment being uploaded.
         * </p>
         * 
         * @param attachmentName
         *        A case-sensitive name of the attachment being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentName(String attachmentName);

        /**
         * <p>
         * A unique case sensitive identifier to support idempotency of request.
         * </p>
         * 
         * @param clientToken
         *        A unique case sensitive identifier to support idempotency of request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The authentication token associated with the participant's connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String contentType;

        private Long attachmentSizeInBytes;

        private String attachmentName;

        private String clientToken;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachmentUploadRequest model) {
            super(model);
            contentType(model.contentType);
            attachmentSizeInBytes(model.attachmentSizeInBytes);
            attachmentName(model.attachmentName);
            clientToken(model.clientToken);
            connectionToken(model.connectionToken);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getAttachmentSizeInBytes() {
            return attachmentSizeInBytes;
        }

        public final void setAttachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
        }

        @Override
        @Transient
        public final Builder attachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
            return this;
        }

        public final String getAttachmentName() {
            return attachmentName;
        }

        public final void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        @Override
        @Transient
        public final Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        @Transient
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAttachmentUploadRequest build() {
            return new StartAttachmentUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
