/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An item - message or event - that has been sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Item implements SdkPojo, Serializable, ToCopyableBuilder<Item.Builder, Item> {
    private static final SdkField<String> ABSOLUTE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbsoluteTime").getter(getter(Item::absoluteTime)).setter(setter(Builder::absoluteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTime").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(Item::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(Item::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Item::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Item::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(Item::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Item::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(Item::participantRoleAsString)).setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<List<AttachmentItem>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentItem>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(Item::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABSOLUTE_TIME_FIELD,
            CONTENT_FIELD, CONTENT_TYPE_FIELD, ID_FIELD, TYPE_FIELD, PARTICIPANT_ID_FIELD, DISPLAY_NAME_FIELD,
            PARTICIPANT_ROLE_FIELD, ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String absoluteTime;

    private final String content;

    private final String contentType;

    private final String id;

    private final String type;

    private final String participantId;

    private final String displayName;

    private final String participantRole;

    private final List<AttachmentItem> attachments;

    private Item(BuilderImpl builder) {
        this.absoluteTime = builder.absoluteTime;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.id = builder.id;
        this.type = builder.type;
        this.participantId = builder.participantId;
        this.displayName = builder.displayName;
        this.participantRole = builder.participantRole;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The time when the message or event was sent.
     * </p>
     * <p>
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The time when the message or event was sent.</p>
     *         <p>
     *         It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public final String absoluteTime() {
        return absoluteTime;
    }

    /**
     * <p>
     * The content of the message or event.
     * </p>
     * 
     * @return The content of the message or event.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The type of content of the item.
     * </p>
     * 
     * @return The type of content of the item.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The ID of the item.
     * </p>
     * 
     * @return The ID of the item.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Type of the item: message or event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChatItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the item: message or event.
     * @see ChatItemType
     */
    public final ChatItemType type() {
        return ChatItemType.fromValue(type);
    }

    /**
     * <p>
     * Type of the item: message or event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChatItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the item: message or event.
     * @see ChatItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the sender in the session.
     * </p>
     * 
     * @return The ID of the sender in the session.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The chat display name of the sender.
     * </p>
     * 
     * @return The chat display name of the sender.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The role of the sender. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the sender. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the sender. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the sender. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return Provides information about the attachments.
     */
    public final List<AttachmentItem> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTime());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item) obj;
        return Objects.equals(absoluteTime(), other.absoluteTime()) && Objects.equals(content(), other.content())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Item").add("AbsoluteTime", absoluteTime()).add("Content", content())
                .add("ContentType", contentType()).add("Id", id()).add("Type", typeAsString())
                .add("ParticipantId", participantId()).add("DisplayName", displayName())
                .add("ParticipantRole", participantRoleAsString()).add("Attachments", hasAttachments() ? attachments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbsoluteTime":
            return Optional.ofNullable(clazz.cast(absoluteTime()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Item> {
        /**
         * <p>
         * The time when the message or event was sent.
         * </p>
         * <p>
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param absoluteTime
         *        The time when the message or event was sent.</p>
         *        <p>
         *        It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTime(String absoluteTime);

        /**
         * <p>
         * The content of the message or event.
         * </p>
         * 
         * @param content
         *        The content of the message or event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The type of content of the item.
         * </p>
         * 
         * @param contentType
         *        The type of content of the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The ID of the item.
         * </p>
         * 
         * @param id
         *        The ID of the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Type of the item: message or event.
         * </p>
         * 
         * @param type
         *        Type of the item: message or event.
         * @see ChatItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatItemType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the item: message or event.
         * </p>
         * 
         * @param type
         *        Type of the item: message or event.
         * @see ChatItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatItemType
         */
        Builder type(ChatItemType type);

        /**
         * <p>
         * The ID of the sender in the session.
         * </p>
         * 
         * @param participantId
         *        The ID of the sender in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The chat display name of the sender.
         * </p>
         * 
         * @param displayName
         *        The chat display name of the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The role of the sender. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the sender. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the sender. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the sender. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * Provides information about the attachments.
         * </p>
         * 
         * @param attachments
         *        Provides information about the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentItem> attachments);

        /**
         * <p>
         * Provides information about the attachments.
         * </p>
         * 
         * @param attachments
         *        Provides information about the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentItem... attachments);

        /**
         * <p>
         * Provides information about the attachments.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttachmentItem>.Builder} avoiding
         * the need to create one manually via {@link List<AttachmentItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #attachments(List<AttachmentItem>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AttachmentItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AttachmentItem>)
         */
        Builder attachments(Consumer<AttachmentItem.Builder>... attachments);
    }

    static final class BuilderImpl implements Builder {
        private String absoluteTime;

        private String content;

        private String contentType;

        private String id;

        private String type;

        private String participantId;

        private String displayName;

        private String participantRole;

        private List<AttachmentItem> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            absoluteTime(model.absoluteTime);
            content(model.content);
            contentType(model.contentType);
            id(model.id);
            type(model.type);
            participantId(model.participantId);
            displayName(model.displayName);
            participantRole(model.participantRole);
            attachments(model.attachments);
        }

        public final String getAbsoluteTime() {
            return absoluteTime;
        }

        public final void setAbsoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
        }

        @Override
        public final Builder absoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChatItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final List<AttachmentItem.Builder> getAttachments() {
            List<AttachmentItem.Builder> result = AttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentItem.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentItem> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentItem... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentItem.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Item build() {
            return new Item(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
