/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ChatItemType {
    TYPING("TYPING"),

    PARTICIPANT_JOINED("PARTICIPANT_JOINED"),

    PARTICIPANT_LEFT("PARTICIPANT_LEFT"),

    CHAT_ENDED("CHAT_ENDED"),

    TRANSFER_SUCCEEDED("TRANSFER_SUCCEEDED"),

    TRANSFER_FAILED("TRANSFER_FAILED"),

    MESSAGE("MESSAGE"),

    EVENT("EVENT"),

    ATTACHMENT("ATTACHMENT"),

    CONNECTION_ACK("CONNECTION_ACK"),

    PARTICIPANT_ACTIVE("PARTICIPANT_ACTIVE"),

    PARTICIPANT_INACTIVE("PARTICIPANT_INACTIVE"),

    PARTICIPANT_ENGAGED("PARTICIPANT_ENGAGED"),

    PARTICIPANT_DISENGAGED("PARTICIPANT_DISENGAGED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChatItemType> VALUE_MAP = EnumUtils.uniqueIndex(ChatItemType.class, ChatItemType::toString);

    private final String value;

    private ChatItemType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ChatItemType corresponding to the value
     */
    public static ChatItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ChatItemType}s
     */
    public static Set<ChatItemType> knownValues() {
        Set<ChatItemType> knownValues = EnumSet.allOf(ChatItemType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
