/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParticipantConnectionResponse extends ConnectParticipantResponse implements
        ToCopyableBuilder<CreateParticipantConnectionResponse.Builder, CreateParticipantConnectionResponse> {
    private static final SdkField<Websocket> WEBSOCKET_FIELD = SdkField.<Websocket> builder(MarshallingType.SDK_POJO)
            .memberName("Websocket").getter(getter(CreateParticipantConnectionResponse::websocket))
            .setter(setter(Builder::websocket)).constructor(Websocket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Websocket").build()).build();

    private static final SdkField<ConnectionCredentials> CONNECTION_CREDENTIALS_FIELD = SdkField
            .<ConnectionCredentials> builder(MarshallingType.SDK_POJO).memberName("ConnectionCredentials")
            .getter(getter(CreateParticipantConnectionResponse::connectionCredentials))
            .setter(setter(Builder::connectionCredentials)).constructor(ConnectionCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionCredentials").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSOCKET_FIELD,
            CONNECTION_CREDENTIALS_FIELD));

    private final Websocket websocket;

    private final ConnectionCredentials connectionCredentials;

    private CreateParticipantConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.websocket = builder.websocket;
        this.connectionCredentials = builder.connectionCredentials;
    }

    /**
     * <p>
     * Creates the participant's websocket connection.
     * </p>
     * 
     * @return Creates the participant's websocket connection.
     */
    public final Websocket websocket() {
        return websocket;
    }

    /**
     * <p>
     * Creates the participant's connection credentials. The authentication token associated with the participant's
     * connection.
     * </p>
     * 
     * @return Creates the participant's connection credentials. The authentication token associated with the
     *         participant's connection.
     */
    public final ConnectionCredentials connectionCredentials() {
        return connectionCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(websocket());
        hashCode = 31 * hashCode + Objects.hashCode(connectionCredentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantConnectionResponse)) {
            return false;
        }
        CreateParticipantConnectionResponse other = (CreateParticipantConnectionResponse) obj;
        return Objects.equals(websocket(), other.websocket())
                && Objects.equals(connectionCredentials(), other.connectionCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateParticipantConnectionResponse").add("Websocket", websocket())
                .add("ConnectionCredentials", connectionCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Websocket":
            return Optional.ofNullable(clazz.cast(websocket()));
        case "ConnectionCredentials":
            return Optional.ofNullable(clazz.cast(connectionCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantConnectionResponse, T> g) {
        return obj -> g.apply((CreateParticipantConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateParticipantConnectionResponse> {
        /**
         * <p>
         * Creates the participant's websocket connection.
         * </p>
         * 
         * @param websocket
         *        Creates the participant's websocket connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websocket(Websocket websocket);

        /**
         * <p>
         * Creates the participant's websocket connection.
         * </p>
         * This is a convenience that creates an instance of the {@link Websocket.Builder} avoiding the need to create
         * one manually via {@link Websocket#builder()}.
         *
         * When the {@link Consumer} completes, {@link Websocket.Builder#build()} is called immediately and its result
         * is passed to {@link #websocket(Websocket)}.
         * 
         * @param websocket
         *        a consumer that will call methods on {@link Websocket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websocket(Websocket)
         */
        default Builder websocket(Consumer<Websocket.Builder> websocket) {
            return websocket(Websocket.builder().applyMutation(websocket).build());
        }

        /**
         * <p>
         * Creates the participant's connection credentials. The authentication token associated with the participant's
         * connection.
         * </p>
         * 
         * @param connectionCredentials
         *        Creates the participant's connection credentials. The authentication token associated with the
         *        participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionCredentials(ConnectionCredentials connectionCredentials);

        /**
         * <p>
         * Creates the participant's connection credentials. The authentication token associated with the participant's
         * connection.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionCredentials.Builder} avoiding the need
         * to create one manually via {@link ConnectionCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionCredentials(ConnectionCredentials)}.
         * 
         * @param connectionCredentials
         *        a consumer that will call methods on {@link ConnectionCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionCredentials(ConnectionCredentials)
         */
        default Builder connectionCredentials(Consumer<ConnectionCredentials.Builder> connectionCredentials) {
            return connectionCredentials(ConnectionCredentials.builder().applyMutation(connectionCredentials).build());
        }
    }

    static final class BuilderImpl extends ConnectParticipantResponse.BuilderImpl implements Builder {
        private Websocket websocket;

        private ConnectionCredentials connectionCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantConnectionResponse model) {
            super(model);
            websocket(model.websocket);
            connectionCredentials(model.connectionCredentials);
        }

        public final Websocket.Builder getWebsocket() {
            return websocket != null ? websocket.toBuilder() : null;
        }

        public final void setWebsocket(Websocket.BuilderImpl websocket) {
            this.websocket = websocket != null ? websocket.build() : null;
        }

        @Override
        @Transient
        public final Builder websocket(Websocket websocket) {
            this.websocket = websocket;
            return this;
        }

        public final ConnectionCredentials.Builder getConnectionCredentials() {
            return connectionCredentials != null ? connectionCredentials.toBuilder() : null;
        }

        public final void setConnectionCredentials(ConnectionCredentials.BuilderImpl connectionCredentials) {
            this.connectionCredentials = connectionCredentials != null ? connectionCredentials.build() : null;
        }

        @Override
        @Transient
        public final Builder connectionCredentials(ConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            return this;
        }

        @Override
        public CreateParticipantConnectionResponse build() {
            return new CreateParticipantConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
