/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParticipantRole {
    AGENT("AGENT"),
    CUSTOMER("CUSTOMER"),
    SYSTEM("SYSTEM"),
    CUSTOM_BOT("CUSTOM_BOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParticipantRole> VALUE_MAP;
    private final String value;

    private ParticipantRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParticipantRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParticipantRole> knownValues() {
        EnumSet<ParticipantRole> knownValues = EnumSet.allOf(ParticipantRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParticipantRole.class, ParticipantRole::toString);
    }
}

