/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Websocket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Websocket> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(Websocket.getter(Websocket::url)).setter(Websocket.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> CONNECTION_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionExpiry").getter(Websocket.getter(Websocket::connectionExpiry)).setter(Websocket.setter(Builder::connectionExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CONNECTION_EXPIRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String connectionExpiry;

    private Websocket(BuilderImpl builder) {
        this.url = builder.url;
        this.connectionExpiry = builder.connectionExpiry;
    }

    public final String url() {
        return this.url;
    }

    public final String connectionExpiry() {
        return this.connectionExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Websocket)) {
            return false;
        }
        Websocket other = (Websocket)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.connectionExpiry(), other.connectionExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"Websocket").add("Url", (Object)this.url()).add("ConnectionExpiry", (Object)this.connectionExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ConnectionExpiry": {
                return Optional.ofNullable(clazz.cast(this.connectionExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Websocket, T> g) {
        return obj -> g.apply((Websocket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String connectionExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(Websocket model) {
            this.url(model.url);
            this.connectionExpiry(model.connectionExpiry);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getConnectionExpiry() {
            return this.connectionExpiry;
        }

        public final void setConnectionExpiry(String connectionExpiry) {
            this.connectionExpiry = connectionExpiry;
        }

        @Override
        public final Builder connectionExpiry(String connectionExpiry) {
            this.connectionExpiry = connectionExpiry;
            return this;
        }

        public Websocket build() {
            return new Websocket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Websocket> {
        public Builder url(String var1);

        public Builder connectionExpiry(String var1);
    }
}

