/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionCredentials> {
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(ConnectionCredentials.getter(ConnectionCredentials::connectionToken)).setter(ConnectionCredentials.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionToken").build()}).build();
    private static final SdkField<String> EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expiry").getter(ConnectionCredentials.getter(ConnectionCredentials::expiry)).setter(ConnectionCredentials.setter(Builder::expiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TOKEN_FIELD, EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionToken;
    private final String expiry;

    private ConnectionCredentials(BuilderImpl builder) {
        this.connectionToken = builder.connectionToken;
        this.expiry = builder.expiry;
    }

    public final String connectionToken() {
        return this.connectionToken;
    }

    public final String expiry() {
        return this.expiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionCredentials)) {
            return false;
        }
        ConnectionCredentials other = (ConnectionCredentials)obj;
        return Objects.equals(this.connectionToken(), other.connectionToken()) && Objects.equals(this.expiry(), other.expiry());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionCredentials").add("ConnectionToken", (Object)this.connectionToken()).add("Expiry", (Object)this.expiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
            case "Expiry": {
                return Optional.ofNullable(clazz.cast(this.expiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionToken", CONNECTION_TOKEN_FIELD);
        map.put("Expiry", EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionCredentials, T> g) {
        return obj -> g.apply((ConnectionCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionToken;
        private String expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionCredentials model) {
            this.connectionToken(model.connectionToken);
            this.expiry(model.expiry);
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final String getExpiry() {
            return this.expiry;
        }

        public final void setExpiry(String expiry) {
            this.expiry = expiry;
        }

        @Override
        public final Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        public ConnectionCredentials build() {
            return new ConnectionCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionCredentials> {
        public Builder connectionToken(String var1);

        public Builder expiry(String var1);
    }
}

