/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteAttachmentUploadRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<CompleteAttachmentUploadRequest.Builder, CompleteAttachmentUploadRequest> {
    private static final SdkField<List<String>> ATTACHMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttachmentIds")
            .getter(getter(CompleteAttachmentUploadRequest::attachmentIds))
            .setter(setter(Builder::attachmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CompleteAttachmentUploadRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionToken").getter(getter(CompleteAttachmentUploadRequest::connectionToken))
            .setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_IDS_FIELD,
            CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> attachmentIds;

    private final String clientToken;

    private final String connectionToken;

    private CompleteAttachmentUploadRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentIds = builder.attachmentIds;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachmentIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachmentIds() {
        return attachmentIds != null && !(attachmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers for the attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachmentIds} method.
     * </p>
     * 
     * @return A list of unique identifiers for the attachments.
     */
    public final List<String> attachmentIds() {
        return attachmentIds;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The authentication token associated with the participant's connection.
     * </p>
     * 
     * @return The authentication token associated with the participant's connection.
     */
    public final String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachmentIds() ? attachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteAttachmentUploadRequest)) {
            return false;
        }
        CompleteAttachmentUploadRequest other = (CompleteAttachmentUploadRequest) obj;
        return hasAttachmentIds() == other.hasAttachmentIds() && Objects.equals(attachmentIds(), other.attachmentIds())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteAttachmentUploadRequest")
                .add("AttachmentIds", hasAttachmentIds() ? attachmentIds() : null).add("ClientToken", clientToken())
                .add("ConnectionToken", connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentIds":
            return Optional.ofNullable(clazz.cast(attachmentIds()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentIds", ATTACHMENT_IDS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("X-Amz-Bearer", CONNECTION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteAttachmentUploadRequest, T> g) {
        return obj -> g.apply((CompleteAttachmentUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CompleteAttachmentUploadRequest> {
        /**
         * <p>
         * A list of unique identifiers for the attachments.
         * </p>
         * 
         * @param attachmentIds
         *        A list of unique identifiers for the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentIds(Collection<String> attachmentIds);

        /**
         * <p>
         * A list of unique identifiers for the attachments.
         * </p>
         * 
         * @param attachmentIds
         *        A list of unique identifiers for the attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentIds(String... attachmentIds);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The authentication token associated with the participant's connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private List<String> attachmentIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteAttachmentUploadRequest model) {
            super(model);
            attachmentIds(model.attachmentIds);
            clientToken(model.clientToken);
            connectionToken(model.connectionToken);
        }

        public final Collection<String> getAttachmentIds() {
            if (attachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return attachmentIds;
        }

        public final void setAttachmentIds(Collection<String> attachmentIds) {
            this.attachmentIds = AttachmentIdListCopier.copy(attachmentIds);
        }

        @Override
        public final Builder attachmentIds(Collection<String> attachmentIds) {
            this.attachmentIds = AttachmentIdListCopier.copy(attachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentIds(String... attachmentIds) {
            attachmentIds(Arrays.asList(attachmentIds));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteAttachmentUploadRequest build() {
            return new CompleteAttachmentUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
