/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthenticationUrlResponse extends ConnectParticipantResponse implements
        ToCopyableBuilder<GetAuthenticationUrlResponse.Builder, GetAuthenticationUrlResponse> {
    private static final SdkField<String> AUTHENTICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationUrl").getter(getter(GetAuthenticationUrlResponse::authenticationUrl))
            .setter(setter(Builder::authenticationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationUrl;

    private GetAuthenticationUrlResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationUrl = builder.authenticationUrl;
    }

    /**
     * <p>
     * The URL where the customer will sign in to the identity provider. This URL contains the authorize endpoint for
     * the Cognito UserPool used in the authentication.
     * </p>
     * 
     * @return The URL where the customer will sign in to the identity provider. This URL contains the authorize
     *         endpoint for the Cognito UserPool used in the authentication.
     */
    public final String authenticationUrl() {
        return authenticationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthenticationUrlResponse)) {
            return false;
        }
        GetAuthenticationUrlResponse other = (GetAuthenticationUrlResponse) obj;
        return Objects.equals(authenticationUrl(), other.authenticationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthenticationUrlResponse").add("AuthenticationUrl", authenticationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationUrl":
            return Optional.ofNullable(clazz.cast(authenticationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationUrl", AUTHENTICATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthenticationUrlResponse, T> g) {
        return obj -> g.apply((GetAuthenticationUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAuthenticationUrlResponse> {
        /**
         * <p>
         * The URL where the customer will sign in to the identity provider. This URL contains the authorize endpoint
         * for the Cognito UserPool used in the authentication.
         * </p>
         * 
         * @param authenticationUrl
         *        The URL where the customer will sign in to the identity provider. This URL contains the authorize
         *        endpoint for the Cognito UserPool used in the authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationUrl(String authenticationUrl);
    }

    static final class BuilderImpl extends ConnectParticipantResponse.BuilderImpl implements Builder {
        private String authenticationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthenticationUrlResponse model) {
            super(model);
            authenticationUrl(model.authenticationUrl);
        }

        public final String getAuthenticationUrl() {
            return authenticationUrl;
        }

        public final void setAuthenticationUrl(String authenticationUrl) {
            this.authenticationUrl = authenticationUrl;
        }

        @Override
        public final Builder authenticationUrl(String authenticationUrl) {
            this.authenticationUrl = authenticationUrl;
            return this;
        }

        @Override
        public GetAuthenticationUrlResponse build() {
            return new GetAuthenticationUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
