/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata related to a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageMetadata implements SdkPojo, Serializable, ToCopyableBuilder<MessageMetadata.Builder, MessageMetadata> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(MessageMetadata::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<List<Receipt>> RECEIPTS_FIELD = SdkField
            .<List<Receipt>> builder(MarshallingType.LIST)
            .memberName("Receipts")
            .getter(getter(MessageMetadata::receipts))
            .setter(setter(Builder::receipts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receipts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Receipt> builder(MarshallingType.SDK_POJO)
                                            .constructor(Receipt::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            RECEIPTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final List<Receipt> receipts;

    private MessageMetadata(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.receipts = builder.receipts;
    }

    /**
     * <p>
     * The identifier of the message that contains the metadata information.
     * </p>
     * 
     * @return The identifier of the message that contains the metadata information.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Receipts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReceipts() {
        return receipts != null && !(receipts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of receipt information for a message for different recipients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceipts} method.
     * </p>
     * 
     * @return The list of receipt information for a message for different recipients.
     */
    public final List<Receipt> receipts() {
        return receipts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReceipts() ? receipts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata other = (MessageMetadata) obj;
        return Objects.equals(messageId(), other.messageId()) && hasReceipts() == other.hasReceipts()
                && Objects.equals(receipts(), other.receipts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageMetadata").add("MessageId", messageId())
                .add("Receipts", hasReceipts() ? receipts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "Receipts":
            return Optional.ofNullable(clazz.cast(receipts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("Receipts", RECEIPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageMetadata, T> g) {
        return obj -> g.apply((MessageMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageMetadata> {
        /**
         * <p>
         * The identifier of the message that contains the metadata information.
         * </p>
         * 
         * @param messageId
         *        The identifier of the message that contains the metadata information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The list of receipt information for a message for different recipients.
         * </p>
         * 
         * @param receipts
         *        The list of receipt information for a message for different recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receipts(Collection<Receipt> receipts);

        /**
         * <p>
         * The list of receipt information for a message for different recipients.
         * </p>
         * 
         * @param receipts
         *        The list of receipt information for a message for different recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receipts(Receipt... receipts);

        /**
         * <p>
         * The list of receipt information for a message for different recipients.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectparticipant.model.Receipt.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connectparticipant.model.Receipt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectparticipant.model.Receipt.Builder#build()} is called
         * immediately and its result is passed to {@link #receipts(List<Receipt>)}.
         * 
         * @param receipts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectparticipant.model.Receipt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receipts(java.util.Collection<Receipt>)
         */
        Builder receipts(Consumer<Receipt.Builder>... receipts);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private List<Receipt> receipts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageMetadata model) {
            messageId(model.messageId);
            receipts(model.receipts);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final List<Receipt.Builder> getReceipts() {
            List<Receipt.Builder> result = ReceiptsCopier.copyToBuilder(this.receipts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReceipts(Collection<Receipt.BuilderImpl> receipts) {
            this.receipts = ReceiptsCopier.copyFromBuilder(receipts);
        }

        @Override
        public final Builder receipts(Collection<Receipt> receipts) {
            this.receipts = ReceiptsCopier.copy(receipts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Receipt... receipts) {
            receipts(Arrays.asList(receipts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receipts(Consumer<Receipt.Builder>... receipts) {
            receipts(Stream.of(receipts).map(c -> Receipt.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MessageMetadata build() {
            return new MessageMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
