/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAttachmentUploadResponse extends ConnectParticipantResponse implements
        ToCopyableBuilder<StartAttachmentUploadResponse.Builder, StartAttachmentUploadResponse> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(StartAttachmentUploadResponse::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<UploadMetadata> UPLOAD_METADATA_FIELD = SdkField
            .<UploadMetadata> builder(MarshallingType.SDK_POJO).memberName("UploadMetadata")
            .getter(getter(StartAttachmentUploadResponse::uploadMetadata)).setter(setter(Builder::uploadMetadata))
            .constructor(UploadMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            UPLOAD_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String attachmentId;

    private final UploadMetadata uploadMetadata;

    private StartAttachmentUploadResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.uploadMetadata = builder.uploadMetadata;
    }

    /**
     * <p>
     * A unique identifier for the attachment.
     * </p>
     * 
     * @return A unique identifier for the attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The headers to be provided while uploading the file to the URL.
     * </p>
     * 
     * @return The headers to be provided while uploading the file to the URL.
     */
    public final UploadMetadata uploadMetadata() {
        return uploadMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachmentUploadResponse)) {
            return false;
        }
        StartAttachmentUploadResponse other = (StartAttachmentUploadResponse) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(uploadMetadata(), other.uploadMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAttachmentUploadResponse").add("AttachmentId", attachmentId())
                .add("UploadMetadata", uploadMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "UploadMetadata":
            return Optional.ofNullable(clazz.cast(uploadMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("UploadMetadata", UPLOAD_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAttachmentUploadResponse, T> g) {
        return obj -> g.apply((StartAttachmentUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAttachmentUploadResponse> {
        /**
         * <p>
         * A unique identifier for the attachment.
         * </p>
         * 
         * @param attachmentId
         *        A unique identifier for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The headers to be provided while uploading the file to the URL.
         * </p>
         * 
         * @param uploadMetadata
         *        The headers to be provided while uploading the file to the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadMetadata(UploadMetadata uploadMetadata);

        /**
         * <p>
         * The headers to be provided while uploading the file to the URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link UploadMetadata.Builder} avoiding the need
         * to create one manually via {@link UploadMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UploadMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #uploadMetadata(UploadMetadata)}.
         * 
         * @param uploadMetadata
         *        a consumer that will call methods on {@link UploadMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadMetadata(UploadMetadata)
         */
        default Builder uploadMetadata(Consumer<UploadMetadata.Builder> uploadMetadata) {
            return uploadMetadata(UploadMetadata.builder().applyMutation(uploadMetadata).build());
        }
    }

    static final class BuilderImpl extends ConnectParticipantResponse.BuilderImpl implements Builder {
        private String attachmentId;

        private UploadMetadata uploadMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachmentUploadResponse model) {
            super(model);
            attachmentId(model.attachmentId);
            uploadMetadata(model.uploadMetadata);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final UploadMetadata.Builder getUploadMetadata() {
            return uploadMetadata != null ? uploadMetadata.toBuilder() : null;
        }

        public final void setUploadMetadata(UploadMetadata.BuilderImpl uploadMetadata) {
            this.uploadMetadata = uploadMetadata != null ? uploadMetadata.build() : null;
        }

        @Override
        public final Builder uploadMetadata(UploadMetadata uploadMetadata) {
            this.uploadMetadata = uploadMetadata;
            return this;
        }

        @Override
        public StartAttachmentUploadResponse build() {
            return new StartAttachmentUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
