/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAttachmentResponse
extends ConnectParticipantResponse
implements ToCopyableBuilder<Builder, GetAttachmentResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(GetAttachmentResponse.getter(GetAttachmentResponse::url)).setter(GetAttachmentResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UrlExpiry").getter(GetAttachmentResponse.getter(GetAttachmentResponse::urlExpiry)).setter(GetAttachmentResponse.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiry").build()}).build();
    private static final SdkField<Long> ATTACHMENT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AttachmentSizeInBytes").getter(GetAttachmentResponse.getter(GetAttachmentResponse::attachmentSizeInBytes)).setter(GetAttachmentResponse.setter(Builder::attachmentSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, URL_EXPIRY_FIELD, ATTACHMENT_SIZE_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAttachmentResponse.memberNameToFieldInitializer();
    private final String url;
    private final String urlExpiry;
    private final Long attachmentSizeInBytes;

    private GetAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
        this.attachmentSizeInBytes = builder.attachmentSizeInBytes;
    }

    public final String url() {
        return this.url;
    }

    public final String urlExpiry() {
        return this.urlExpiry;
    }

    public final Long attachmentSizeInBytes() {
        return this.attachmentSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttachmentResponse)) {
            return false;
        }
        GetAttachmentResponse other = (GetAttachmentResponse)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry()) && Objects.equals(this.attachmentSizeInBytes(), other.attachmentSizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"GetAttachmentResponse").add("Url", (Object)this.url()).add("UrlExpiry", (Object)this.urlExpiry()).add("AttachmentSizeInBytes", (Object)this.attachmentSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UrlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
            case "AttachmentSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.attachmentSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("UrlExpiry", URL_EXPIRY_FIELD);
        map.put("AttachmentSizeInBytes", ATTACHMENT_SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAttachmentResponse, T> g) {
        return obj -> g.apply((GetAttachmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantResponse.BuilderImpl
    implements Builder {
        private String url;
        private String urlExpiry;
        private Long attachmentSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttachmentResponse model) {
            super(model);
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
            this.attachmentSizeInBytes(model.attachmentSizeInBytes);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(String urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(String urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public final Long getAttachmentSizeInBytes() {
            return this.attachmentSizeInBytes;
        }

        public final void setAttachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
        }

        @Override
        public final Builder attachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
            return this;
        }

        @Override
        public GetAttachmentResponse build() {
            return new GetAttachmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectParticipantResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAttachmentResponse> {
        public Builder url(String var1);

        public Builder urlExpiry(String var1);

        public Builder attachmentSizeInBytes(Long var1);
    }
}

