/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filtering option for where to start. For example, if you sent 100 messages, start with message 50.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPosition implements SdkPojo, Serializable, ToCopyableBuilder<StartPosition.Builder, StartPosition> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StartPosition::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ABSOLUTE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbsoluteTime").getter(getter(StartPosition::absoluteTime)).setter(setter(Builder::absoluteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTime").build()).build();

    private static final SdkField<Integer> MOST_RECENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MostRecent").getter(getter(StartPosition::mostRecent)).setter(setter(Builder::mostRecent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MostRecent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ABSOLUTE_TIME_FIELD,
            MOST_RECENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String absoluteTime;

    private final Integer mostRecent;

    private StartPosition(BuilderImpl builder) {
        this.id = builder.id;
        this.absoluteTime = builder.absoluteTime;
        this.mostRecent = builder.mostRecent;
    }

    /**
     * <p>
     * The ID of the message or event where to start.
     * </p>
     * 
     * @return The ID of the message or event where to start.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time in ISO format where to start.
     * </p>
     * <p>
     * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The time in ISO format where to start.</p>
     *         <p>
     *         It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public final String absoluteTime() {
        return absoluteTime;
    }

    /**
     * <p>
     * The start position of the most recent message where you want to start.
     * </p>
     * 
     * @return The start position of the most recent message where you want to start.
     */
    public final Integer mostRecent() {
        return mostRecent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTime());
        hashCode = 31 * hashCode + Objects.hashCode(mostRecent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPosition)) {
            return false;
        }
        StartPosition other = (StartPosition) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(absoluteTime(), other.absoluteTime())
                && Objects.equals(mostRecent(), other.mostRecent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPosition").add("Id", id()).add("AbsoluteTime", absoluteTime())
                .add("MostRecent", mostRecent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AbsoluteTime":
            return Optional.ofNullable(clazz.cast(absoluteTime()));
        case "MostRecent":
            return Optional.ofNullable(clazz.cast(mostRecent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("AbsoluteTime", ABSOLUTE_TIME_FIELD);
        map.put("MostRecent", MOST_RECENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPosition, T> g) {
        return obj -> g.apply((StartPosition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartPosition> {
        /**
         * <p>
         * The ID of the message or event where to start.
         * </p>
         * 
         * @param id
         *        The ID of the message or event where to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time in ISO format where to start.
         * </p>
         * <p>
         * It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param absoluteTime
         *        The time in ISO format where to start.</p>
         *        <p>
         *        It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTime(String absoluteTime);

        /**
         * <p>
         * The start position of the most recent message where you want to start.
         * </p>
         * 
         * @param mostRecent
         *        The start position of the most recent message where you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mostRecent(Integer mostRecent);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String absoluteTime;

        private Integer mostRecent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPosition model) {
            id(model.id);
            absoluteTime(model.absoluteTime);
            mostRecent(model.mostRecent);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAbsoluteTime() {
            return absoluteTime;
        }

        public final void setAbsoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
        }

        @Override
        public final Builder absoluteTime(String absoluteTime) {
            this.absoluteTime = absoluteTime;
            return this;
        }

        public final Integer getMostRecent() {
            return mostRecent;
        }

        public final void setMostRecent(Integer mostRecent) {
            this.mostRecent = mostRecent;
        }

        @Override
        public final Builder mostRecent(Integer mostRecent) {
            this.mostRecent = mostRecent;
            return this;
        }

        @Override
        public StartPosition build() {
            return new StartPosition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
