/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebRTCMediaPlacement implements SdkPojo, Serializable,
        ToCopyableBuilder<WebRTCMediaPlacement.Builder, WebRTCMediaPlacement> {
    private static final SdkField<String> AUDIO_HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioHostUrl").getter(getter(WebRTCMediaPlacement::audioHostUrl)).setter(setter(Builder::audioHostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioHostUrl").build()).build();

    private static final SdkField<String> AUDIO_FALLBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioFallbackUrl").getter(getter(WebRTCMediaPlacement::audioFallbackUrl))
            .setter(setter(Builder::audioFallbackUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioFallbackUrl").build()).build();

    private static final SdkField<String> SIGNALING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalingUrl").getter(getter(WebRTCMediaPlacement::signalingUrl)).setter(setter(Builder::signalingUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalingUrl").build()).build();

    private static final SdkField<String> EVENT_INGESTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventIngestionUrl").getter(getter(WebRTCMediaPlacement::eventIngestionUrl))
            .setter(setter(Builder::eventIngestionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIngestionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_HOST_URL_FIELD,
            AUDIO_FALLBACK_URL_FIELD, SIGNALING_URL_FIELD, EVENT_INGESTION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String audioHostUrl;

    private final String audioFallbackUrl;

    private final String signalingUrl;

    private final String eventIngestionUrl;

    private WebRTCMediaPlacement(BuilderImpl builder) {
        this.audioHostUrl = builder.audioHostUrl;
        this.audioFallbackUrl = builder.audioFallbackUrl;
        this.signalingUrl = builder.signalingUrl;
        this.eventIngestionUrl = builder.eventIngestionUrl;
    }

    /**
     * <p>
     * The audio host URL.
     * </p>
     * 
     * @return The audio host URL.
     */
    public final String audioHostUrl() {
        return audioHostUrl;
    }

    /**
     * <p>
     * The audio fallback URL.
     * </p>
     * 
     * @return The audio fallback URL.
     */
    public final String audioFallbackUrl() {
        return audioFallbackUrl;
    }

    /**
     * <p>
     * The signaling URL.
     * </p>
     * 
     * @return The signaling URL.
     */
    public final String signalingUrl() {
        return signalingUrl;
    }

    /**
     * <p>
     * The event ingestion URL to which you send client meeting events.
     * </p>
     * 
     * @return The event ingestion URL to which you send client meeting events.
     */
    public final String eventIngestionUrl() {
        return eventIngestionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioHostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(audioFallbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(signalingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(eventIngestionUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebRTCMediaPlacement)) {
            return false;
        }
        WebRTCMediaPlacement other = (WebRTCMediaPlacement) obj;
        return Objects.equals(audioHostUrl(), other.audioHostUrl())
                && Objects.equals(audioFallbackUrl(), other.audioFallbackUrl())
                && Objects.equals(signalingUrl(), other.signalingUrl())
                && Objects.equals(eventIngestionUrl(), other.eventIngestionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebRTCMediaPlacement").add("AudioHostUrl", audioHostUrl())
                .add("AudioFallbackUrl", audioFallbackUrl()).add("SignalingUrl", signalingUrl())
                .add("EventIngestionUrl", eventIngestionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioHostUrl":
            return Optional.ofNullable(clazz.cast(audioHostUrl()));
        case "AudioFallbackUrl":
            return Optional.ofNullable(clazz.cast(audioFallbackUrl()));
        case "SignalingUrl":
            return Optional.ofNullable(clazz.cast(signalingUrl()));
        case "EventIngestionUrl":
            return Optional.ofNullable(clazz.cast(eventIngestionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AudioHostUrl", AUDIO_HOST_URL_FIELD);
        map.put("AudioFallbackUrl", AUDIO_FALLBACK_URL_FIELD);
        map.put("SignalingUrl", SIGNALING_URL_FIELD);
        map.put("EventIngestionUrl", EVENT_INGESTION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebRTCMediaPlacement, T> g) {
        return obj -> g.apply((WebRTCMediaPlacement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebRTCMediaPlacement> {
        /**
         * <p>
         * The audio host URL.
         * </p>
         * 
         * @param audioHostUrl
         *        The audio host URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioHostUrl(String audioHostUrl);

        /**
         * <p>
         * The audio fallback URL.
         * </p>
         * 
         * @param audioFallbackUrl
         *        The audio fallback URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioFallbackUrl(String audioFallbackUrl);

        /**
         * <p>
         * The signaling URL.
         * </p>
         * 
         * @param signalingUrl
         *        The signaling URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalingUrl(String signalingUrl);

        /**
         * <p>
         * The event ingestion URL to which you send client meeting events.
         * </p>
         * 
         * @param eventIngestionUrl
         *        The event ingestion URL to which you send client meeting events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIngestionUrl(String eventIngestionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String audioHostUrl;

        private String audioFallbackUrl;

        private String signalingUrl;

        private String eventIngestionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(WebRTCMediaPlacement model) {
            audioHostUrl(model.audioHostUrl);
            audioFallbackUrl(model.audioFallbackUrl);
            signalingUrl(model.signalingUrl);
            eventIngestionUrl(model.eventIngestionUrl);
        }

        public final String getAudioHostUrl() {
            return audioHostUrl;
        }

        public final void setAudioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
        }

        @Override
        public final Builder audioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
            return this;
        }

        public final String getAudioFallbackUrl() {
            return audioFallbackUrl;
        }

        public final void setAudioFallbackUrl(String audioFallbackUrl) {
            this.audioFallbackUrl = audioFallbackUrl;
        }

        @Override
        public final Builder audioFallbackUrl(String audioFallbackUrl) {
            this.audioFallbackUrl = audioFallbackUrl;
            return this;
        }

        public final String getSignalingUrl() {
            return signalingUrl;
        }

        public final void setSignalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
        }

        @Override
        public final Builder signalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
            return this;
        }

        public final String getEventIngestionUrl() {
            return eventIngestionUrl;
        }

        public final void setEventIngestionUrl(String eventIngestionUrl) {
            this.eventIngestionUrl = eventIngestionUrl;
        }

        @Override
        public final Builder eventIngestionUrl(String eventIngestionUrl) {
            this.eventIngestionUrl = eventIngestionUrl;
            return this;
        }

        @Override
        public WebRTCMediaPlacement build() {
            return new WebRTCMediaPlacement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
