/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A meeting created using the Amazon Chime SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebRTCMeeting implements SdkPojo, Serializable, ToCopyableBuilder<WebRTCMeeting.Builder, WebRTCMeeting> {
    private static final SdkField<WebRTCMediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField
            .<WebRTCMediaPlacement> builder(MarshallingType.SDK_POJO).memberName("MediaPlacement")
            .getter(getter(WebRTCMeeting::mediaPlacement)).setter(setter(Builder::mediaPlacement))
            .constructor(WebRTCMediaPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()).build();

    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField
            .<MeetingFeaturesConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingFeatures")
            .getter(getter(WebRTCMeeting::meetingFeatures)).setter(setter(Builder::meetingFeatures))
            .constructor(MeetingFeaturesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()).build();

    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(WebRTCMeeting::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PLACEMENT_FIELD,
            MEETING_FEATURES_FIELD, MEETING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WebRTCMediaPlacement mediaPlacement;

    private final MeetingFeaturesConfiguration meetingFeatures;

    private final String meetingId;

    private WebRTCMeeting(BuilderImpl builder) {
        this.mediaPlacement = builder.mediaPlacement;
        this.meetingFeatures = builder.meetingFeatures;
        this.meetingId = builder.meetingId;
    }

    /**
     * <p>
     * The media placement for the meeting.
     * </p>
     * 
     * @return The media placement for the meeting.
     */
    public final WebRTCMediaPlacement mediaPlacement() {
        return mediaPlacement;
    }

    /**
     * Returns the value of the MeetingFeatures property for this object.
     * 
     * @return The value of the MeetingFeatures property for this object.
     */
    public final MeetingFeaturesConfiguration meetingFeatures() {
        return meetingFeatures;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public final String meetingId() {
        return meetingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebRTCMeeting)) {
            return false;
        }
        WebRTCMeeting other = (WebRTCMeeting) obj;
        return Objects.equals(mediaPlacement(), other.mediaPlacement())
                && Objects.equals(meetingFeatures(), other.meetingFeatures()) && Objects.equals(meetingId(), other.meetingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebRTCMeeting").add("MediaPlacement", mediaPlacement())
                .add("MeetingFeatures", meetingFeatures()).add("MeetingId", meetingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaPlacement":
            return Optional.ofNullable(clazz.cast(mediaPlacement()));
        case "MeetingFeatures":
            return Optional.ofNullable(clazz.cast(meetingFeatures()));
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaPlacement", MEDIA_PLACEMENT_FIELD);
        map.put("MeetingFeatures", MEETING_FEATURES_FIELD);
        map.put("MeetingId", MEETING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebRTCMeeting, T> g) {
        return obj -> g.apply((WebRTCMeeting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebRTCMeeting> {
        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * 
         * @param mediaPlacement
         *        The media placement for the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPlacement(WebRTCMediaPlacement mediaPlacement);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebRTCMediaPlacement.Builder} avoiding
         * the need to create one manually via {@link WebRTCMediaPlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebRTCMediaPlacement.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaPlacement(WebRTCMediaPlacement)}.
         * 
         * @param mediaPlacement
         *        a consumer that will call methods on {@link WebRTCMediaPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPlacement(WebRTCMediaPlacement)
         */
        default Builder mediaPlacement(Consumer<WebRTCMediaPlacement.Builder> mediaPlacement) {
            return mediaPlacement(WebRTCMediaPlacement.builder().applyMutation(mediaPlacement).build());
        }

        /**
         * Sets the value of the MeetingFeatures property for this object.
         *
         * @param meetingFeatures
         *        The new value for the MeetingFeatures property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures);

        /**
         * Sets the value of the MeetingFeatures property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MeetingFeaturesConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingFeaturesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingFeaturesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingFeatures(MeetingFeaturesConfiguration)}.
         * 
         * @param meetingFeatures
         *        a consumer that will call methods on {@link MeetingFeaturesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingFeatures(MeetingFeaturesConfiguration)
         */
        default Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return meetingFeatures(MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures).build());
        }

        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);
    }

    static final class BuilderImpl implements Builder {
        private WebRTCMediaPlacement mediaPlacement;

        private MeetingFeaturesConfiguration meetingFeatures;

        private String meetingId;

        private BuilderImpl() {
        }

        private BuilderImpl(WebRTCMeeting model) {
            mediaPlacement(model.mediaPlacement);
            meetingFeatures(model.meetingFeatures);
            meetingId(model.meetingId);
        }

        public final WebRTCMediaPlacement.Builder getMediaPlacement() {
            return mediaPlacement != null ? mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(WebRTCMediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        public final Builder mediaPlacement(WebRTCMediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return meetingFeatures != null ? meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        @Override
        public WebRTCMeeting build() {
            return new WebRTCMeeting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
