/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.MeetingFeaturesConfiguration;
import software.amazon.awssdk.services.connectparticipant.model.WebRTCMediaPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebRTCMeeting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebRTCMeeting> {
    private static final SdkField<WebRTCMediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPlacement").getter(WebRTCMeeting.getter(WebRTCMeeting::mediaPlacement)).setter(WebRTCMeeting.setter(Builder::mediaPlacement)).constructor(WebRTCMediaPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()}).build();
    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingFeatures").getter(WebRTCMeeting.getter(WebRTCMeeting::meetingFeatures)).setter(WebRTCMeeting.setter(Builder::meetingFeatures)).constructor(MeetingFeaturesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()}).build();
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(WebRTCMeeting.getter(WebRTCMeeting::meetingId)).setter(WebRTCMeeting.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PLACEMENT_FIELD, MEETING_FEATURES_FIELD, MEETING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebRTCMeeting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WebRTCMediaPlacement mediaPlacement;
    private final MeetingFeaturesConfiguration meetingFeatures;
    private final String meetingId;

    private WebRTCMeeting(BuilderImpl builder) {
        this.mediaPlacement = builder.mediaPlacement;
        this.meetingFeatures = builder.meetingFeatures;
        this.meetingId = builder.meetingId;
    }

    public final WebRTCMediaPlacement mediaPlacement() {
        return this.mediaPlacement;
    }

    public final MeetingFeaturesConfiguration meetingFeatures() {
        return this.meetingFeatures;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebRTCMeeting)) {
            return false;
        }
        WebRTCMeeting other = (WebRTCMeeting)obj;
        return Objects.equals(this.mediaPlacement(), other.mediaPlacement()) && Objects.equals(this.meetingFeatures(), other.meetingFeatures()) && Objects.equals(this.meetingId(), other.meetingId());
    }

    public final String toString() {
        return ToString.builder((String)"WebRTCMeeting").add("MediaPlacement", (Object)this.mediaPlacement()).add("MeetingFeatures", (Object)this.meetingFeatures()).add("MeetingId", (Object)this.meetingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPlacement": {
                return Optional.ofNullable(clazz.cast(this.mediaPlacement()));
            }
            case "MeetingFeatures": {
                return Optional.ofNullable(clazz.cast(this.meetingFeatures()));
            }
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaPlacement", MEDIA_PLACEMENT_FIELD);
        map.put("MeetingFeatures", MEETING_FEATURES_FIELD);
        map.put("MeetingId", MEETING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebRTCMeeting, T> g) {
        return obj -> g.apply((WebRTCMeeting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebRTCMediaPlacement mediaPlacement;
        private MeetingFeaturesConfiguration meetingFeatures;
        private String meetingId;

        private BuilderImpl() {
        }

        private BuilderImpl(WebRTCMeeting model) {
            this.mediaPlacement(model.mediaPlacement);
            this.meetingFeatures(model.meetingFeatures);
            this.meetingId(model.meetingId);
        }

        public final WebRTCMediaPlacement.Builder getMediaPlacement() {
            return this.mediaPlacement != null ? this.mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(WebRTCMediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        public final Builder mediaPlacement(WebRTCMediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return this.meetingFeatures != null ? this.meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public WebRTCMeeting build() {
            return new WebRTCMeeting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebRTCMeeting> {
        public Builder mediaPlacement(WebRTCMediaPlacement var1);

        default public Builder mediaPlacement(Consumer<WebRTCMediaPlacement.Builder> mediaPlacement) {
            return this.mediaPlacement((WebRTCMediaPlacement)((WebRTCMediaPlacement.Builder)WebRTCMediaPlacement.builder().applyMutation(mediaPlacement)).build());
        }

        public Builder meetingFeatures(MeetingFeaturesConfiguration var1);

        default public Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return this.meetingFeatures((MeetingFeaturesConfiguration)((MeetingFeaturesConfiguration.Builder)MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures)).build());
        }

        public Builder meetingId(String var1);
    }
}

