/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantResponse;
import software.amazon.awssdk.services.connectparticipant.model.ConnectionCredentials;
import software.amazon.awssdk.services.connectparticipant.model.WebRTCConnection;
import software.amazon.awssdk.services.connectparticipant.model.Websocket;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateParticipantConnectionResponse
extends ConnectParticipantResponse
implements ToCopyableBuilder<Builder, CreateParticipantConnectionResponse> {
    private static final SdkField<Websocket> WEBSOCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Websocket").getter(CreateParticipantConnectionResponse.getter(CreateParticipantConnectionResponse::websocket)).setter(CreateParticipantConnectionResponse.setter(Builder::websocket)).constructor(Websocket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Websocket").build()}).build();
    private static final SdkField<ConnectionCredentials> CONNECTION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionCredentials").getter(CreateParticipantConnectionResponse.getter(CreateParticipantConnectionResponse::connectionCredentials)).setter(CreateParticipantConnectionResponse.setter(Builder::connectionCredentials)).constructor(ConnectionCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionCredentials").build()}).build();
    private static final SdkField<WebRTCConnection> WEB_RTC_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebRTCConnection").getter(CreateParticipantConnectionResponse.getter(CreateParticipantConnectionResponse::webRTCConnection)).setter(CreateParticipantConnectionResponse.setter(Builder::webRTCConnection)).constructor(WebRTCConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebRTCConnection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSOCKET_FIELD, CONNECTION_CREDENTIALS_FIELD, WEB_RTC_CONNECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateParticipantConnectionResponse.memberNameToFieldInitializer();
    private final Websocket websocket;
    private final ConnectionCredentials connectionCredentials;
    private final WebRTCConnection webRTCConnection;

    private CreateParticipantConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.websocket = builder.websocket;
        this.connectionCredentials = builder.connectionCredentials;
        this.webRTCConnection = builder.webRTCConnection;
    }

    public final Websocket websocket() {
        return this.websocket;
    }

    public final ConnectionCredentials connectionCredentials() {
        return this.connectionCredentials;
    }

    public final WebRTCConnection webRTCConnection() {
        return this.webRTCConnection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.websocket());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.webRTCConnection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantConnectionResponse)) {
            return false;
        }
        CreateParticipantConnectionResponse other = (CreateParticipantConnectionResponse)((Object)obj);
        return Objects.equals(this.websocket(), other.websocket()) && Objects.equals(this.connectionCredentials(), other.connectionCredentials()) && Objects.equals(this.webRTCConnection(), other.webRTCConnection());
    }

    public final String toString() {
        return ToString.builder((String)"CreateParticipantConnectionResponse").add("Websocket", (Object)this.websocket()).add("ConnectionCredentials", (Object)this.connectionCredentials()).add("WebRTCConnection", (Object)this.webRTCConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Websocket": {
                return Optional.ofNullable(clazz.cast(this.websocket()));
            }
            case "ConnectionCredentials": {
                return Optional.ofNullable(clazz.cast(this.connectionCredentials()));
            }
            case "WebRTCConnection": {
                return Optional.ofNullable(clazz.cast(this.webRTCConnection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Websocket", WEBSOCKET_FIELD);
        map.put("ConnectionCredentials", CONNECTION_CREDENTIALS_FIELD);
        map.put("WebRTCConnection", WEB_RTC_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantConnectionResponse, T> g) {
        return obj -> g.apply((CreateParticipantConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantResponse.BuilderImpl
    implements Builder {
        private Websocket websocket;
        private ConnectionCredentials connectionCredentials;
        private WebRTCConnection webRTCConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantConnectionResponse model) {
            super(model);
            this.websocket(model.websocket);
            this.connectionCredentials(model.connectionCredentials);
            this.webRTCConnection(model.webRTCConnection);
        }

        public final Websocket.Builder getWebsocket() {
            return this.websocket != null ? this.websocket.toBuilder() : null;
        }

        public final void setWebsocket(Websocket.BuilderImpl websocket) {
            this.websocket = websocket != null ? websocket.build() : null;
        }

        @Override
        public final Builder websocket(Websocket websocket) {
            this.websocket = websocket;
            return this;
        }

        public final ConnectionCredentials.Builder getConnectionCredentials() {
            return this.connectionCredentials != null ? this.connectionCredentials.toBuilder() : null;
        }

        public final void setConnectionCredentials(ConnectionCredentials.BuilderImpl connectionCredentials) {
            this.connectionCredentials = connectionCredentials != null ? connectionCredentials.build() : null;
        }

        @Override
        public final Builder connectionCredentials(ConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            return this;
        }

        public final WebRTCConnection.Builder getWebRTCConnection() {
            return this.webRTCConnection != null ? this.webRTCConnection.toBuilder() : null;
        }

        public final void setWebRTCConnection(WebRTCConnection.BuilderImpl webRTCConnection) {
            this.webRTCConnection = webRTCConnection != null ? webRTCConnection.build() : null;
        }

        @Override
        public final Builder webRTCConnection(WebRTCConnection webRTCConnection) {
            this.webRTCConnection = webRTCConnection;
            return this;
        }

        @Override
        public CreateParticipantConnectionResponse build() {
            return new CreateParticipantConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectParticipantResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateParticipantConnectionResponse> {
        public Builder websocket(Websocket var1);

        default public Builder websocket(Consumer<Websocket.Builder> websocket) {
            return this.websocket((Websocket)((Websocket.Builder)Websocket.builder().applyMutation(websocket)).build());
        }

        public Builder connectionCredentials(ConnectionCredentials var1);

        default public Builder connectionCredentials(Consumer<ConnectionCredentials.Builder> connectionCredentials) {
            return this.connectionCredentials((ConnectionCredentials)((ConnectionCredentials.Builder)ConnectionCredentials.builder().applyMutation(connectionCredentials)).build());
        }

        public Builder webRTCConnection(WebRTCConnection var1);

        default public Builder webRTCConnection(Consumer<WebRTCConnection.Builder> webRTCConnection) {
            return this.webRTCConnection((WebRTCConnection)((WebRTCConnection.Builder)WebRTCConnection.builder().applyMutation(webRTCConnection)).build());
        }
    }
}

