/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAttachmentRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, GetAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(GetAttachmentRequest.getter(GetAttachmentRequest::attachmentId)).setter(GetAttachmentRequest.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(GetAttachmentRequest.getter(GetAttachmentRequest::connectionToken)).setter(GetAttachmentRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final SdkField<Integer> URL_EXPIRY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UrlExpiryInSeconds").getter(GetAttachmentRequest.getter(GetAttachmentRequest::urlExpiryInSeconds)).setter(GetAttachmentRequest.setter(Builder::urlExpiryInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiryInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, CONNECTION_TOKEN_FIELD, URL_EXPIRY_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAttachmentRequest.memberNameToFieldInitializer();
    private final String attachmentId;
    private final String connectionToken;
    private final Integer urlExpiryInSeconds;

    private GetAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.connectionToken = builder.connectionToken;
        this.urlExpiryInSeconds = builder.urlExpiryInSeconds;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String connectionToken() {
        return this.connectionToken;
    }

    public final Integer urlExpiryInSeconds() {
        return this.urlExpiryInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiryInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttachmentRequest)) {
            return false;
        }
        GetAttachmentRequest other = (GetAttachmentRequest)((Object)obj);
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.connectionToken(), other.connectionToken()) && Objects.equals(this.urlExpiryInSeconds(), other.urlExpiryInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"GetAttachmentRequest").add("AttachmentId", (Object)this.attachmentId()).add("ConnectionToken", (Object)this.connectionToken()).add("UrlExpiryInSeconds", (Object)this.urlExpiryInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
            case "UrlExpiryInSeconds": {
                return Optional.ofNullable(clazz.cast(this.urlExpiryInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("X-Amz-Bearer", CONNECTION_TOKEN_FIELD);
        map.put("UrlExpiryInSeconds", URL_EXPIRY_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAttachmentRequest, T> g) {
        return obj -> g.apply((GetAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private String attachmentId;
        private String connectionToken;
        private Integer urlExpiryInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttachmentRequest model) {
            super(model);
            this.attachmentId(model.attachmentId);
            this.connectionToken(model.connectionToken);
            this.urlExpiryInSeconds(model.urlExpiryInSeconds);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final Integer getUrlExpiryInSeconds() {
            return this.urlExpiryInSeconds;
        }

        public final void setUrlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
        }

        @Override
        public final Builder urlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAttachmentRequest build() {
            return new GetAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAttachmentRequest> {
        public Builder attachmentId(String var1);

        public Builder connectionToken(String var1);

        public Builder urlExpiryInSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

