/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommonControlsRequest extends ControlCatalogRequest implements
        ToCopyableBuilder<ListCommonControlsRequest.Builder, ListCommonControlsRequest> {
    private static final SdkField<CommonControlFilter> COMMON_CONTROL_FILTER_FIELD = SdkField
            .<CommonControlFilter> builder(MarshallingType.SDK_POJO).memberName("CommonControlFilter")
            .getter(getter(ListCommonControlsRequest::commonControlFilter)).setter(setter(Builder::commonControlFilter))
            .constructor(CommonControlFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControlFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCommonControlsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCommonControlsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMON_CONTROL_FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final CommonControlFilter commonControlFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListCommonControlsRequest(BuilderImpl builder) {
        super(builder);
        this.commonControlFilter = builder.commonControlFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An optional filter that narrows the results to a specific objective.
     * </p>
     * <p>
     * This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the
     * <code>CommonControlFilter</code> isn’t currently supported.
     * </p>
     * 
     * @return An optional filter that narrows the results to a specific objective.</p>
     *         <p>
     *         This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the
     *         <code>CommonControlFilter</code> isn’t currently supported.
     */
    public final CommonControlFilter commonControlFilter() {
        return commonControlFilter;
    }

    /**
     * <p>
     * The maximum number of results on a page or for an API request call.
     * </p>
     * 
     * @return The maximum number of results on a page or for an API request call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commonControlFilter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommonControlsRequest)) {
            return false;
        }
        ListCommonControlsRequest other = (ListCommonControlsRequest) obj;
        return Objects.equals(commonControlFilter(), other.commonControlFilter())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCommonControlsRequest").add("CommonControlFilter", commonControlFilter())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommonControlFilter":
            return Optional.ofNullable(clazz.cast(commonControlFilter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCommonControlsRequest, T> g) {
        return obj -> g.apply((ListCommonControlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCommonControlsRequest> {
        /**
         * <p>
         * An optional filter that narrows the results to a specific objective.
         * </p>
         * <p>
         * This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the
         * <code>CommonControlFilter</code> isn’t currently supported.
         * </p>
         * 
         * @param commonControlFilter
         *        An optional filter that narrows the results to a specific objective.</p>
         *        <p>
         *        This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the
         *        <code>CommonControlFilter</code> isn’t currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonControlFilter(CommonControlFilter commonControlFilter);

        /**
         * <p>
         * An optional filter that narrows the results to a specific objective.
         * </p>
         * <p>
         * This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the
         * <code>CommonControlFilter</code> isn’t currently supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommonControlFilter.Builder} avoiding the
         * need to create one manually via {@link CommonControlFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommonControlFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #commonControlFilter(CommonControlFilter)}.
         * 
         * @param commonControlFilter
         *        a consumer that will call methods on {@link CommonControlFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commonControlFilter(CommonControlFilter)
         */
        default Builder commonControlFilter(Consumer<CommonControlFilter.Builder> commonControlFilter) {
            return commonControlFilter(CommonControlFilter.builder().applyMutation(commonControlFilter).build());
        }

        /**
         * <p>
         * The maximum number of results on a page or for an API request call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results on a page or for an API request call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlCatalogRequest.BuilderImpl implements Builder {
        private CommonControlFilter commonControlFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommonControlsRequest model) {
            super(model);
            commonControlFilter(model.commonControlFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final CommonControlFilter.Builder getCommonControlFilter() {
            return commonControlFilter != null ? commonControlFilter.toBuilder() : null;
        }

        public final void setCommonControlFilter(CommonControlFilter.BuilderImpl commonControlFilter) {
            this.commonControlFilter = commonControlFilter != null ? commonControlFilter.build() : null;
        }

        @Override
        public final Builder commonControlFilter(CommonControlFilter commonControlFilter) {
            this.commonControlFilter = commonControlFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommonControlsRequest build() {
            return new ListCommonControlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
