/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of metadata for a common control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommonControlSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CommonControlSummary.Builder, CommonControlSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CommonControlSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CommonControlSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CommonControlSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AssociatedDomainSummary> DOMAIN_FIELD = SdkField
            .<AssociatedDomainSummary> builder(MarshallingType.SDK_POJO).memberName("Domain")
            .getter(getter(CommonControlSummary::domain)).setter(setter(Builder::domain))
            .constructor(AssociatedDomainSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<AssociatedObjectiveSummary> OBJECTIVE_FIELD = SdkField
            .<AssociatedObjectiveSummary> builder(MarshallingType.SDK_POJO).memberName("Objective")
            .getter(getter(CommonControlSummary::objective)).setter(setter(Builder::objective))
            .constructor(AssociatedObjectiveSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objective").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(CommonControlSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(CommonControlSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DOMAIN_FIELD, OBJECTIVE_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final AssociatedDomainSummary domain;

    private final AssociatedObjectiveSummary objective;

    private final Instant createTime;

    private final Instant lastUpdateTime;

    private CommonControlSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.domain = builder.domain;
        this.objective = builder.objective;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the common control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the common control.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the common control.
     * </p>
     * 
     * @return The name of the common control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the common control.
     * </p>
     * 
     * @return The description of the common control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain that the common control belongs to.
     * </p>
     * 
     * @return The domain that the common control belongs to.
     */
    public final AssociatedDomainSummary domain() {
        return domain;
    }

    /**
     * <p>
     * The objective that the common control belongs to.
     * </p>
     * 
     * @return The objective that the common control belongs to.
     */
    public final AssociatedObjectiveSummary objective() {
        return objective;
    }

    /**
     * <p>
     * The time when the common control was created.
     * </p>
     * 
     * @return The time when the common control was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time when the common control was most recently updated.
     * </p>
     * 
     * @return The time when the common control was most recently updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(objective());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonControlSummary)) {
            return false;
        }
        CommonControlSummary other = (CommonControlSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(domain(), other.domain())
                && Objects.equals(objective(), other.objective()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommonControlSummary").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Domain", domain()).add("Objective", objective()).add("CreateTime", createTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Objective":
            return Optional.ofNullable(clazz.cast(objective()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommonControlSummary, T> g) {
        return obj -> g.apply((CommonControlSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommonControlSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the common control.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that identifies the common control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the common control.
         * </p>
         * 
         * @param name
         *        The name of the common control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the common control.
         * </p>
         * 
         * @param description
         *        The description of the common control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain that the common control belongs to.
         * </p>
         * 
         * @param domain
         *        The domain that the common control belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(AssociatedDomainSummary domain);

        /**
         * <p>
         * The domain that the common control belongs to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociatedDomainSummary.Builder} avoiding
         * the need to create one manually via {@link AssociatedDomainSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociatedDomainSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #domain(AssociatedDomainSummary)}.
         * 
         * @param domain
         *        a consumer that will call methods on {@link AssociatedDomainSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domain(AssociatedDomainSummary)
         */
        default Builder domain(Consumer<AssociatedDomainSummary.Builder> domain) {
            return domain(AssociatedDomainSummary.builder().applyMutation(domain).build());
        }

        /**
         * <p>
         * The objective that the common control belongs to.
         * </p>
         * 
         * @param objective
         *        The objective that the common control belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objective(AssociatedObjectiveSummary objective);

        /**
         * <p>
         * The objective that the common control belongs to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociatedObjectiveSummary.Builder}
         * avoiding the need to create one manually via {@link AssociatedObjectiveSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociatedObjectiveSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #objective(AssociatedObjectiveSummary)}.
         * 
         * @param objective
         *        a consumer that will call methods on {@link AssociatedObjectiveSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objective(AssociatedObjectiveSummary)
         */
        default Builder objective(Consumer<AssociatedObjectiveSummary.Builder> objective) {
            return objective(AssociatedObjectiveSummary.builder().applyMutation(objective).build());
        }

        /**
         * <p>
         * The time when the common control was created.
         * </p>
         * 
         * @param createTime
         *        The time when the common control was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time when the common control was most recently updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time when the common control was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private AssociatedDomainSummary domain;

        private AssociatedObjectiveSummary objective;

        private Instant createTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CommonControlSummary model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            domain(model.domain);
            objective(model.objective);
            createTime(model.createTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AssociatedDomainSummary.Builder getDomain() {
            return domain != null ? domain.toBuilder() : null;
        }

        public final void setDomain(AssociatedDomainSummary.BuilderImpl domain) {
            this.domain = domain != null ? domain.build() : null;
        }

        @Override
        public final Builder domain(AssociatedDomainSummary domain) {
            this.domain = domain;
            return this;
        }

        public final AssociatedObjectiveSummary.Builder getObjective() {
            return objective != null ? objective.toBuilder() : null;
        }

        public final void setObjective(AssociatedObjectiveSummary.BuilderImpl objective) {
            this.objective = objective != null ? objective.build() : null;
        }

        @Override
        public final Builder objective(AssociatedObjectiveSummary objective) {
            this.objective = objective;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public CommonControlSummary build() {
            return new CommonControlSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
