/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetControlResponse extends ControlCatalogResponse implements
        ToCopyableBuilder<GetControlResponse.Builder, GetControlResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetControlResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetControlResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetControlResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Behavior").getter(getter(GetControlResponse::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()).build();

    private static final SdkField<RegionConfiguration> REGION_CONFIGURATION_FIELD = SdkField
            .<RegionConfiguration> builder(MarshallingType.SDK_POJO).memberName("RegionConfiguration")
            .getter(getter(GetControlResponse::regionConfiguration)).setter(setter(Builder::regionConfiguration))
            .constructor(RegionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, BEHAVIOR_FIELD, REGION_CONFIGURATION_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final String behavior;

    private final RegionConfiguration regionConfiguration;

    private GetControlResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.behavior = builder.behavior;
        this.regionConfiguration = builder.regionConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The display name of the control.
     * </p>
     * 
     * @return The display name of the control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of what the control does.
     * </p>
     * 
     * @return A description of what the control does.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A term that identifies the control's functional behavior. One of <code>Preventive</code>, <code>Deteictive</code>, <code>Proactive</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link ControlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return A term that identifies the control's functional behavior. One of <code>Preventive</code>,
     *         <code>Deteictive</code>, <code>Proactive</code>
     * @see ControlBehavior
     */
    public final ControlBehavior behavior() {
        return ControlBehavior.fromValue(behavior);
    }

    /**
     * <p>
     * A term that identifies the control's functional behavior. One of <code>Preventive</code>, <code>Deteictive</code>, <code>Proactive</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link ControlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return A term that identifies the control's functional behavior. One of <code>Preventive</code>,
     *         <code>Deteictive</code>, <code>Proactive</code>
     * @see ControlBehavior
     */
    public final String behaviorAsString() {
        return behavior;
    }

    /**
     * Returns the value of the RegionConfiguration property for this object.
     * 
     * @return The value of the RegionConfiguration property for this object.
     */
    public final RegionConfiguration regionConfiguration() {
        return regionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetControlResponse)) {
            return false;
        }
        GetControlResponse other = (GetControlResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(behaviorAsString(), other.behaviorAsString())
                && Objects.equals(regionConfiguration(), other.regionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetControlResponse").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Behavior", behaviorAsString()).add("RegionConfiguration", regionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        case "RegionConfiguration":
            return Optional.ofNullable(clazz.cast(regionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetControlResponse, T> g) {
        return obj -> g.apply((GetControlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetControlResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The display name of the control.
         * </p>
         * 
         * @param name
         *        The display name of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of what the control does.
         * </p>
         * 
         * @param description
         *        A description of what the control does.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A term that identifies the control's functional behavior. One of <code>Preventive</code>,
         * <code>Deteictive</code>, <code>Proactive</code>
         * </p>
         * 
         * @param behavior
         *        A term that identifies the control's functional behavior. One of <code>Preventive</code>,
         *        <code>Deteictive</code>, <code>Proactive</code>
         * @see ControlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlBehavior
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * A term that identifies the control's functional behavior. One of <code>Preventive</code>,
         * <code>Deteictive</code>, <code>Proactive</code>
         * </p>
         * 
         * @param behavior
         *        A term that identifies the control's functional behavior. One of <code>Preventive</code>,
         *        <code>Deteictive</code>, <code>Proactive</code>
         * @see ControlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlBehavior
         */
        Builder behavior(ControlBehavior behavior);

        /**
         * Sets the value of the RegionConfiguration property for this object.
         *
         * @param regionConfiguration
         *        The new value for the RegionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionConfiguration(RegionConfiguration regionConfiguration);

        /**
         * Sets the value of the RegionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RegionConfiguration.Builder} avoiding the
         * need to create one manually via {@link RegionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #regionConfiguration(RegionConfiguration)}.
         * 
         * @param regionConfiguration
         *        a consumer that will call methods on {@link RegionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionConfiguration(RegionConfiguration)
         */
        default Builder regionConfiguration(Consumer<RegionConfiguration.Builder> regionConfiguration) {
            return regionConfiguration(RegionConfiguration.builder().applyMutation(regionConfiguration).build());
        }
    }

    static final class BuilderImpl extends ControlCatalogResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String behavior;

        private RegionConfiguration regionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetControlResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            behavior(model.behavior);
            regionConfiguration(model.regionConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBehavior() {
            return behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(ControlBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final RegionConfiguration.Builder getRegionConfiguration() {
            return regionConfiguration != null ? regionConfiguration.toBuilder() : null;
        }

        public final void setRegionConfiguration(RegionConfiguration.BuilderImpl regionConfiguration) {
            this.regionConfiguration = regionConfiguration != null ? regionConfiguration.build() : null;
        }

        @Override
        public final Builder regionConfiguration(RegionConfiguration regionConfiguration) {
            this.regionConfiguration = regionConfiguration;
            return this;
        }

        @Override
        public GetControlResponse build() {
            return new GetControlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
