/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Four types of control parameters are supported.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>AllowedRegions</b>: List of Amazon Web Services Regions exempted from the control. Each string is expected to be
 * an Amazon Web Services Region code. This parameter is mandatory for the <b>OU Region deny</b> control,
 * <b>CT.MULTISERVICE.PV.1</b>.
 * </p>
 * <p>
 * Example: <code>["us-east-1","us-west-2"]</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>ExemptedActions</b>: List of Amazon Web Services IAM actions exempted from the control. Each string is expected to
 * be an IAM action.
 * </p>
 * <p>
 * Example: <code>["logs:DescribeLogGroups","logs:StartQuery","logs:GetQueryResults"]</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>ExemptedPrincipalArns</b>: List of Amazon Web Services IAM principal ARNs exempted from the control. Each string
 * is expected to be an IAM principal that follows the pattern <code>^arn:(aws|aws-us-gov):(iam|sts)::.+:.+$</code>
 * </p>
 * <p>
 * Example: <code>["arn:aws:iam::*:role/ReadOnly","arn:aws:sts::*:assumed-role/ReadOnly/*"]</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>ExemptedResourceArns</b>: List of resource ARNs exempted from the control. Each string is expected to be a
 * resource ARN.
 * </p>
 * <p>
 * Example: <code>["arn:aws:s3:::my-bucket-name"]</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlParameter.Builder, ControlParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ControlParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private ControlParameter(BuilderImpl builder) {
        this.name = builder.name;
    }

    /**
     * <p>
     * The parameter name. This name is the parameter <code>key</code> when you call <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html">
     * <code>EnableControl</code> </a> or <a
     * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html">
     * <code>UpdateEnabledControl</code> </a>.
     * </p>
     * 
     * @return The parameter name. This name is the parameter <code>key</code> when you call <a
     *         href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html">
     *         <code>EnableControl</code> </a> or <a
     *         href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html">
     *         <code>UpdateEnabledControl</code> </a>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlParameter)) {
            return false;
        }
        ControlParameter other = (ControlParameter) obj;
        return Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlParameter").add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlParameter, T> g) {
        return obj -> g.apply((ControlParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlParameter> {
        /**
         * <p>
         * The parameter name. This name is the parameter <code>key</code> when you call <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html">
         * <code>EnableControl</code> </a> or <a
         * href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html">
         * <code>UpdateEnabledControl</code> </a>.
         * </p>
         * 
         * @param name
         *        The parameter name. This name is the parameter <code>key</code> when you call <a
         *        href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html">
         *        <code>EnableControl</code> </a> or <a
         *        href="https://docs.aws.amazon.com/controltower/latest/APIReference/API_UpdateEnabledControl.html">
         *        <code>UpdateEnabledControl</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlParameter model) {
            name(model.name);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ControlParameter build() {
            return new ControlParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
