/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controlcatalog.model.Mapping;
import software.amazon.awssdk.services.controlcatalog.model.MappingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlMapping> {
    private static final SdkField<String> CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlArn").getter(ControlMapping.getter(ControlMapping::controlArn)).setter(ControlMapping.setter(Builder::controlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArn").build()}).build();
    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MappingType").getter(ControlMapping.getter(ControlMapping::mappingTypeAsString)).setter(ControlMapping.setter(Builder::mappingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingType").build()}).build();
    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mapping").getter(ControlMapping.getter(ControlMapping::mapping)).setter(ControlMapping.setter(Builder::mapping)).constructor(Mapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARN_FIELD, MAPPING_TYPE_FIELD, MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String controlArn;
    private final String mappingType;
    private final Mapping mapping;

    private ControlMapping(BuilderImpl builder) {
        this.controlArn = builder.controlArn;
        this.mappingType = builder.mappingType;
        this.mapping = builder.mapping;
    }

    public final String controlArn() {
        return this.controlArn;
    }

    public final MappingType mappingType() {
        return MappingType.fromValue(this.mappingType);
    }

    public final String mappingTypeAsString() {
        return this.mappingType;
    }

    public final Mapping mapping() {
        return this.mapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlMapping)) {
            return false;
        }
        ControlMapping other = (ControlMapping)obj;
        return Objects.equals(this.controlArn(), other.controlArn()) && Objects.equals(this.mappingTypeAsString(), other.mappingTypeAsString()) && Objects.equals(this.mapping(), other.mapping());
    }

    public final String toString() {
        return ToString.builder((String)"ControlMapping").add("ControlArn", (Object)this.controlArn()).add("MappingType", (Object)this.mappingTypeAsString()).add("Mapping", (Object)this.mapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlArn": {
                return Optional.ofNullable(clazz.cast(this.controlArn()));
            }
            case "MappingType": {
                return Optional.ofNullable(clazz.cast(this.mappingTypeAsString()));
            }
            case "Mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ControlArn", CONTROL_ARN_FIELD);
        map.put("MappingType", MAPPING_TYPE_FIELD);
        map.put("Mapping", MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlMapping, T> g) {
        return obj -> g.apply((ControlMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlArn;
        private String mappingType;
        private Mapping mapping;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlMapping model) {
            this.controlArn(model.controlArn);
            this.mappingType(model.mappingType);
            this.mapping(model.mapping);
        }

        public final String getControlArn() {
            return this.controlArn;
        }

        public final void setControlArn(String controlArn) {
            this.controlArn = controlArn;
        }

        @Override
        public final Builder controlArn(String controlArn) {
            this.controlArn = controlArn;
            return this;
        }

        public final String getMappingType() {
            return this.mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final Mapping.Builder getMapping() {
            return this.mapping != null ? this.mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public ControlMapping build() {
            return new ControlMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlMapping> {
        public Builder controlArn(String var1);

        public Builder mappingType(String var1);

        public Builder mappingType(MappingType var1);

        public Builder mapping(Mapping var1);

        default public Builder mapping(Consumer<Mapping.Builder> mapping) {
            return this.mapping((Mapping)((Mapping.Builder)Mapping.builder().applyMutation(mapping)).build());
        }
    }
}

