/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a control mapping, including the control ARN, mapping type, and mapping
 * details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlMapping implements SdkPojo, Serializable, ToCopyableBuilder<ControlMapping.Builder, ControlMapping> {
    private static final SdkField<String> CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlArn").getter(getter(ControlMapping::controlArn)).setter(setter(Builder::controlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArn").build()).build();

    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MappingType").getter(getter(ControlMapping::mappingTypeAsString)).setter(setter(Builder::mappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingType").build()).build();

    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.<Mapping> builder(MarshallingType.SDK_POJO)
            .memberName("Mapping").getter(getter(ControlMapping::mapping)).setter(setter(Builder::mapping))
            .constructor(Mapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARN_FIELD,
            MAPPING_TYPE_FIELD, MAPPING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String controlArn;

    private final String mappingType;

    private final Mapping mapping;

    private ControlMapping(BuilderImpl builder) {
        this.controlArn = builder.controlArn;
        this.mappingType = builder.mappingType;
        this.mapping = builder.mapping;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the control in the mapping.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the control in the mapping.
     */
    public final String controlArn() {
        return controlArn;
    }

    /**
     * <p>
     * The type of mapping relationship between the control and other entities. Indicates whether the mapping is to a
     * framework or common control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return The type of mapping relationship between the control and other entities. Indicates whether the mapping is
     *         to a framework or common control.
     * @see MappingType
     */
    public final MappingType mappingType() {
        return MappingType.fromValue(mappingType);
    }

    /**
     * <p>
     * The type of mapping relationship between the control and other entities. Indicates whether the mapping is to a
     * framework or common control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return The type of mapping relationship between the control and other entities. Indicates whether the mapping is
     *         to a framework or common control.
     * @see MappingType
     */
    public final String mappingTypeAsString() {
        return mappingType;
    }

    /**
     * <p>
     * The details of the mapping relationship, containing either framework or common control information.
     * </p>
     * 
     * @return The details of the mapping relationship, containing either framework or common control information.
     */
    public final Mapping mapping() {
        return mapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlArn());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mapping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlMapping)) {
            return false;
        }
        ControlMapping other = (ControlMapping) obj;
        return Objects.equals(controlArn(), other.controlArn())
                && Objects.equals(mappingTypeAsString(), other.mappingTypeAsString())
                && Objects.equals(mapping(), other.mapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlMapping").add("ControlArn", controlArn()).add("MappingType", mappingTypeAsString())
                .add("Mapping", mapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlArn":
            return Optional.ofNullable(clazz.cast(controlArn()));
        case "MappingType":
            return Optional.ofNullable(clazz.cast(mappingTypeAsString()));
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlArn", CONTROL_ARN_FIELD);
        map.put("MappingType", MAPPING_TYPE_FIELD);
        map.put("Mapping", MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlMapping, T> g) {
        return obj -> g.apply((ControlMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlMapping> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the control in the mapping.
         * </p>
         * 
         * @param controlArn
         *        The Amazon Resource Name (ARN) that identifies the control in the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlArn(String controlArn);

        /**
         * <p>
         * The type of mapping relationship between the control and other entities. Indicates whether the mapping is to
         * a framework or common control.
         * </p>
         * 
         * @param mappingType
         *        The type of mapping relationship between the control and other entities. Indicates whether the mapping
         *        is to a framework or common control.
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(String mappingType);

        /**
         * <p>
         * The type of mapping relationship between the control and other entities. Indicates whether the mapping is to
         * a framework or common control.
         * </p>
         * 
         * @param mappingType
         *        The type of mapping relationship between the control and other entities. Indicates whether the mapping
         *        is to a framework or common control.
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(MappingType mappingType);

        /**
         * <p>
         * The details of the mapping relationship, containing either framework or common control information.
         * </p>
         * 
         * @param mapping
         *        The details of the mapping relationship, containing either framework or common control information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Mapping mapping);

        /**
         * <p>
         * The details of the mapping relationship, containing either framework or common control information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Mapping.Builder} avoiding the need to
         * create one manually via {@link Mapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mapping.Builder#build()} is called immediately and its result is
         * passed to {@link #mapping(Mapping)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link Mapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(Mapping)
         */
        default Builder mapping(Consumer<Mapping.Builder> mapping) {
            return mapping(Mapping.builder().applyMutation(mapping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String controlArn;

        private String mappingType;

        private Mapping mapping;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlMapping model) {
            controlArn(model.controlArn);
            mappingType(model.mappingType);
            mapping(model.mapping);
        }

        public final String getControlArn() {
            return controlArn;
        }

        public final void setControlArn(String controlArn) {
            this.controlArn = controlArn;
        }

        @Override
        public final Builder controlArn(String controlArn) {
            this.controlArn = controlArn;
            return this;
        }

        public final String getMappingType() {
            return mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final Mapping.Builder getMapping() {
            return mapping != null ? mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        @Override
        public ControlMapping build() {
            return new ControlMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
