/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Overview of information about a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlSummary implements SdkPojo, Serializable, ToCopyableBuilder<ControlSummary.Builder, ControlSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ControlSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> ALIASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Aliases")
            .getter(getter(ControlSummary::aliases))
            .setter(setter(Builder::aliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ControlSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ControlSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Behavior").getter(getter(ControlSummary::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ControlSummary::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<ImplementationSummary> IMPLEMENTATION_FIELD = SdkField
            .<ImplementationSummary> builder(MarshallingType.SDK_POJO).memberName("Implementation")
            .getter(getter(ControlSummary::implementation)).setter(setter(Builder::implementation))
            .constructor(ImplementationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Implementation").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ControlSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<List<String>> GOVERNED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GovernedResources")
            .getter(getter(ControlSummary::governedResources))
            .setter(setter(Builder::governedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GovernedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALIASES_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, BEHAVIOR_FIELD, SEVERITY_FIELD, IMPLEMENTATION_FIELD, CREATE_TIME_FIELD,
            GOVERNED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> aliases;

    private final String name;

    private final String description;

    private final String behavior;

    private final String severity;

    private final ImplementationSummary implementation;

    private final Instant createTime;

    private final List<String> governedResources;

    private ControlSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.aliases = builder.aliases;
        this.name = builder.name;
        this.description = builder.description;
        this.behavior = builder.behavior;
        this.severity = builder.severity;
        this.implementation = builder.implementation;
        this.createTime = builder.createTime;
        this.governedResources = builder.governedResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aliases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAliases() {
        return aliases != null && !(aliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of alternative identifiers for the control. These are human-readable designators, such as
     * <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web Services services
     * or compliance frameworks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliases} method.
     * </p>
     * 
     * @return A list of alternative identifiers for the control. These are human-readable designators, such as
     *         <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web Services
     *         services or compliance frameworks.
     */
    public final List<String> aliases() {
        return aliases;
    }

    /**
     * <p>
     * The display name of the control.
     * </p>
     * 
     * @return The display name of the control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the control, as it may appear in the console. Describes the functionality of the control.
     * </p>
     * 
     * @return A description of the control, as it may appear in the console. Describes the functionality of the
     *         control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An enumerated type, with the following possible values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link ControlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return An enumerated type, with the following possible values:
     * @see ControlBehavior
     */
    public final ControlBehavior behavior() {
        return ControlBehavior.fromValue(behavior);
    }

    /**
     * <p>
     * An enumerated type, with the following possible values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link ControlBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return An enumerated type, with the following possible values:
     * @see ControlBehavior
     */
    public final String behaviorAsString() {
        return behavior;
    }

    /**
     * <p>
     * An enumerated type, with the following possible values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ControlSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An enumerated type, with the following possible values:
     * @see ControlSeverity
     */
    public final ControlSeverity severity() {
        return ControlSeverity.fromValue(severity);
    }

    /**
     * <p>
     * An enumerated type, with the following possible values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ControlSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An enumerated type, with the following possible values:
     * @see ControlSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * An object of type <code>ImplementationSummary</code> that describes how the control is implemented.
     * </p>
     * 
     * @return An object of type <code>ImplementationSummary</code> that describes how the control is implemented.
     */
    public final ImplementationSummary implementation() {
        return implementation;
    }

    /**
     * <p>
     * A timestamp that notes the time when the control was released (start of its life) as a governance capability in
     * Amazon Web Services.
     * </p>
     * 
     * @return A timestamp that notes the time when the control was released (start of its life) as a governance
     *         capability in Amazon Web Services.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the GovernedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGovernedResources() {
        return governedResources != null && !(governedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services resource types that are governed by this control. This information helps you
     * understand which controls can govern certain types of resources, and conversely, which resources are affected
     * when the control is implemented. The resources are represented as Amazon Web Services CloudFormation resource
     * types. If <code>GovernedResources</code> cannot be represented by available CloudFormation resource types, it’s
     * returned as an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGovernedResources} method.
     * </p>
     * 
     * @return A list of Amazon Web Services resource types that are governed by this control. This information helps
     *         you understand which controls can govern certain types of resources, and conversely, which resources are
     *         affected when the control is implemented. The resources are represented as Amazon Web Services
     *         CloudFormation resource types. If <code>GovernedResources</code> cannot be represented by available
     *         CloudFormation resource types, it’s returned as an empty list.
     */
    public final List<String> governedResources() {
        return governedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAliases() ? aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(implementation());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasGovernedResources() ? governedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlSummary)) {
            return false;
        }
        ControlSummary other = (ControlSummary) obj;
        return Objects.equals(arn(), other.arn()) && hasAliases() == other.hasAliases()
                && Objects.equals(aliases(), other.aliases()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(behaviorAsString(), other.behaviorAsString())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(implementation(), other.implementation()) && Objects.equals(createTime(), other.createTime())
                && hasGovernedResources() == other.hasGovernedResources()
                && Objects.equals(governedResources(), other.governedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlSummary").add("Arn", arn()).add("Aliases", hasAliases() ? aliases() : null)
                .add("Name", name()).add("Description", description()).add("Behavior", behaviorAsString())
                .add("Severity", severityAsString()).add("Implementation", implementation()).add("CreateTime", createTime())
                .add("GovernedResources", hasGovernedResources() ? governedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Implementation":
            return Optional.ofNullable(clazz.cast(implementation()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "GovernedResources":
            return Optional.ofNullable(clazz.cast(governedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Behavior", BEHAVIOR_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Implementation", IMPLEMENTATION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("GovernedResources", GOVERNED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlSummary, T> g) {
        return obj -> g.apply((ControlSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of alternative identifiers for the control. These are human-readable designators, such as
         * <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web Services
         * services or compliance frameworks.
         * </p>
         * 
         * @param aliases
         *        A list of alternative identifiers for the control. These are human-readable designators, such as
         *        <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web
         *        Services services or compliance frameworks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Collection<String> aliases);

        /**
         * <p>
         * A list of alternative identifiers for the control. These are human-readable designators, such as
         * <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web Services
         * services or compliance frameworks.
         * </p>
         * 
         * @param aliases
         *        A list of alternative identifiers for the control. These are human-readable designators, such as
         *        <code>SH.S3.1</code>. Several aliases can refer to the same control across different Amazon Web
         *        Services services or compliance frameworks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(String... aliases);

        /**
         * <p>
         * The display name of the control.
         * </p>
         * 
         * @param name
         *        The display name of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the control, as it may appear in the console. Describes the functionality of the control.
         * </p>
         * 
         * @param description
         *        A description of the control, as it may appear in the console. Describes the functionality of the
         *        control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An enumerated type, with the following possible values:
         * </p>
         * 
         * @param behavior
         *        An enumerated type, with the following possible values:
         * @see ControlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlBehavior
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * An enumerated type, with the following possible values:
         * </p>
         * 
         * @param behavior
         *        An enumerated type, with the following possible values:
         * @see ControlBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlBehavior
         */
        Builder behavior(ControlBehavior behavior);

        /**
         * <p>
         * An enumerated type, with the following possible values:
         * </p>
         * 
         * @param severity
         *        An enumerated type, with the following possible values:
         * @see ControlSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * An enumerated type, with the following possible values:
         * </p>
         * 
         * @param severity
         *        An enumerated type, with the following possible values:
         * @see ControlSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlSeverity
         */
        Builder severity(ControlSeverity severity);

        /**
         * <p>
         * An object of type <code>ImplementationSummary</code> that describes how the control is implemented.
         * </p>
         * 
         * @param implementation
         *        An object of type <code>ImplementationSummary</code> that describes how the control is implemented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder implementation(ImplementationSummary implementation);

        /**
         * <p>
         * An object of type <code>ImplementationSummary</code> that describes how the control is implemented.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImplementationSummary.Builder} avoiding
         * the need to create one manually via {@link ImplementationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImplementationSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #implementation(ImplementationSummary)}.
         * 
         * @param implementation
         *        a consumer that will call methods on {@link ImplementationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #implementation(ImplementationSummary)
         */
        default Builder implementation(Consumer<ImplementationSummary.Builder> implementation) {
            return implementation(ImplementationSummary.builder().applyMutation(implementation).build());
        }

        /**
         * <p>
         * A timestamp that notes the time when the control was released (start of its life) as a governance capability
         * in Amazon Web Services.
         * </p>
         * 
         * @param createTime
         *        A timestamp that notes the time when the control was released (start of its life) as a governance
         *        capability in Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * A list of Amazon Web Services resource types that are governed by this control. This information helps you
         * understand which controls can govern certain types of resources, and conversely, which resources are affected
         * when the control is implemented. The resources are represented as Amazon Web Services CloudFormation resource
         * types. If <code>GovernedResources</code> cannot be represented by available CloudFormation resource types,
         * it’s returned as an empty list.
         * </p>
         * 
         * @param governedResources
         *        A list of Amazon Web Services resource types that are governed by this control. This information helps
         *        you understand which controls can govern certain types of resources, and conversely, which resources
         *        are affected when the control is implemented. The resources are represented as Amazon Web Services
         *        CloudFormation resource types. If <code>GovernedResources</code> cannot be represented by available
         *        CloudFormation resource types, it’s returned as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedResources(Collection<String> governedResources);

        /**
         * <p>
         * A list of Amazon Web Services resource types that are governed by this control. This information helps you
         * understand which controls can govern certain types of resources, and conversely, which resources are affected
         * when the control is implemented. The resources are represented as Amazon Web Services CloudFormation resource
         * types. If <code>GovernedResources</code> cannot be represented by available CloudFormation resource types,
         * it’s returned as an empty list.
         * </p>
         * 
         * @param governedResources
         *        A list of Amazon Web Services resource types that are governed by this control. This information helps
         *        you understand which controls can govern certain types of resources, and conversely, which resources
         *        are affected when the control is implemented. The resources are represented as Amazon Web Services
         *        CloudFormation resource types. If <code>GovernedResources</code> cannot be represented by available
         *        CloudFormation resource types, it’s returned as an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder governedResources(String... governedResources);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> aliases = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String description;

        private String behavior;

        private String severity;

        private ImplementationSummary implementation;

        private Instant createTime;

        private List<String> governedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlSummary model) {
            arn(model.arn);
            aliases(model.aliases);
            name(model.name);
            description(model.description);
            behavior(model.behavior);
            severity(model.severity);
            implementation(model.implementation);
            createTime(model.createTime);
            governedResources(model.governedResources);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAliases() {
            if (aliases instanceof SdkAutoConstructList) {
                return null;
            }
            return aliases;
        }

        public final void setAliases(Collection<String> aliases) {
            this.aliases = ControlAliasesCopier.copy(aliases);
        }

        @Override
        public final Builder aliases(Collection<String> aliases) {
            this.aliases = ControlAliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(String... aliases) {
            aliases(Arrays.asList(aliases));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBehavior() {
            return behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(ControlBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ControlSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final ImplementationSummary.Builder getImplementation() {
            return implementation != null ? implementation.toBuilder() : null;
        }

        public final void setImplementation(ImplementationSummary.BuilderImpl implementation) {
            this.implementation = implementation != null ? implementation.build() : null;
        }

        @Override
        public final Builder implementation(ImplementationSummary implementation) {
            this.implementation = implementation;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Collection<String> getGovernedResources() {
            if (governedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return governedResources;
        }

        public final void setGovernedResources(Collection<String> governedResources) {
            this.governedResources = GovernedResourcesCopier.copy(governedResources);
        }

        @Override
        public final Builder governedResources(Collection<String> governedResources) {
            this.governedResources = GovernedResourcesCopier.copy(governedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder governedResources(String... governedResources) {
            governedResources(Arrays.asList(governedResources));
            return this;
        }

        @Override
        public ControlSummary build() {
            return new ControlSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
