/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details about a common control mapping. In particular, it returns the Amazon Resource Name
 * (ARN) of the common control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommonControlMappingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CommonControlMappingDetails.Builder, CommonControlMappingDetails> {
    private static final SdkField<String> COMMON_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommonControlArn").getter(getter(CommonControlMappingDetails::commonControlArn))
            .setter(setter(Builder::commonControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControlArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMON_CONTROL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commonControlArn;

    private CommonControlMappingDetails(BuilderImpl builder) {
        this.commonControlArn = builder.commonControlArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the common control in the mapping.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the common control in the mapping.
     */
    public final String commonControlArn() {
        return commonControlArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commonControlArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonControlMappingDetails)) {
            return false;
        }
        CommonControlMappingDetails other = (CommonControlMappingDetails) obj;
        return Objects.equals(commonControlArn(), other.commonControlArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommonControlMappingDetails").add("CommonControlArn", commonControlArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommonControlArn":
            return Optional.ofNullable(clazz.cast(commonControlArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CommonControlArn", COMMON_CONTROL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommonControlMappingDetails, T> g) {
        return obj -> g.apply((CommonControlMappingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommonControlMappingDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the common control in the mapping.
         * </p>
         * 
         * @param commonControlArn
         *        The Amazon Resource Name (ARN) that identifies the common control in the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonControlArn(String commonControlArn);
    }

    static final class BuilderImpl implements Builder {
        private String commonControlArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CommonControlMappingDetails model) {
            commonControlArn(model.commonControlArn);
        }

        public final String getCommonControlArn() {
            return commonControlArn;
        }

        public final void setCommonControlArn(String commonControlArn) {
            this.commonControlArn = commonControlArn;
        }

        @Override
        public final Builder commonControlArn(String commonControlArn) {
            this.commonControlArn = commonControlArn;
            return this;
        }

        @Override
        public CommonControlMappingDetails build() {
            return new CommonControlMappingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
