/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines filtering criteria for control implementations. You can use this filter to find controls
 * that are implemented by specific Amazon Web Services services or with specific service identifiers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImplementationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ImplementationFilter.Builder, ImplementationFilter> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Types")
            .getter(getter(ImplementationFilter::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Identifiers")
            .getter(getter(ImplementationFilter::identifiers))
            .setter(setter(Builder::identifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TYPES_FIELD, IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> types;

    private final List<String> identifiers;

    private ImplementationFilter(BuilderImpl builder) {
        this.types = builder.types;
        this.identifiers = builder.identifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of implementation types that can serve as filters. For example, you can filter for controls implemented as
     * Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return A list of implementation types that can serve as filters. For example, you can filter for controls
     *         implemented as Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
     */
    public final List<String> types() {
        return types;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentifiers() {
        return identifiers != null && !(identifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of service-specific identifiers that can serve as filters. For example, you can filter for controls with
     * specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifiers} method.
     * </p>
     * 
     * @return A list of service-specific identifiers that can serve as filters. For example, you can filter for
     *         controls with specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
     */
    public final List<String> identifiers() {
        return identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifiers() ? identifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplementationFilter)) {
            return false;
        }
        ImplementationFilter other = (ImplementationFilter) obj;
        return hasTypes() == other.hasTypes() && Objects.equals(types(), other.types())
                && hasIdentifiers() == other.hasIdentifiers() && Objects.equals(identifiers(), other.identifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImplementationFilter").add("Types", hasTypes() ? types() : null)
                .add("Identifiers", hasIdentifiers() ? identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "Identifiers":
            return Optional.ofNullable(clazz.cast(identifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Types", TYPES_FIELD);
        map.put("Identifiers", IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImplementationFilter, T> g) {
        return obj -> g.apply((ImplementationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImplementationFilter> {
        /**
         * <p>
         * A list of implementation types that can serve as filters. For example, you can filter for controls
         * implemented as Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
         * </p>
         * 
         * @param types
         *        A list of implementation types that can serve as filters. For example, you can filter for controls
         *        implemented as Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * A list of implementation types that can serve as filters. For example, you can filter for controls
         * implemented as Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
         * </p>
         * 
         * @param types
         *        A list of implementation types that can serve as filters. For example, you can filter for controls
         *        implemented as Amazon Web Services Config Rules by specifying AWS::Config::ConfigRule as a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * A list of service-specific identifiers that can serve as filters. For example, you can filter for controls
         * with specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
         * </p>
         * 
         * @param identifiers
         *        A list of service-specific identifiers that can serve as filters. For example, you can filter for
         *        controls with specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(Collection<String> identifiers);

        /**
         * <p>
         * A list of service-specific identifiers that can serve as filters. For example, you can filter for controls
         * with specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
         * </p>
         * 
         * @param identifiers
         *        A list of service-specific identifiers that can serve as filters. For example, you can filter for
         *        controls with specific Amazon Web Services Config Rule IDs or Security Hub Control IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(String... identifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private List<String> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImplementationFilter model) {
            types(model.types);
            identifiers(model.identifiers);
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ImplementationTypeFilterListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = ImplementationTypeFilterListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getIdentifiers() {
            if (identifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return identifiers;
        }

        public final void setIdentifiers(Collection<String> identifiers) {
            this.identifiers = ImplementationIdentifierFilterListCopier.copy(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<String> identifiers) {
            this.identifiers = ImplementationIdentifierFilterListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(String... identifiers) {
            identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        public ImplementationFilter build() {
            return new ImplementationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
