/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of how the control is implemented, including the Amazon Web Services service that enforces the control and
 * its service-specific identifier. For example, the value of this field could indicate that the control is implemented
 * as an Amazon Web Services Config Rule or an Amazon Web Services Security Hub control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImplementationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImplementationSummary.Builder, ImplementationSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ImplementationSummary::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ImplementationSummary::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String identifier;

    private ImplementationSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * A string that represents the Amazon Web Services service that implements this control. For example, a value of
     * <code>AWS::Config::ConfigRule</code> indicates that the control is implemented by Amazon Web Services Config, and
     * <code>AWS::SecurityHub::SecurityControl</code> indicates implementation by Amazon Web Services Security Hub.
     * </p>
     * 
     * @return A string that represents the Amazon Web Services service that implements this control. For example, a
     *         value of <code>AWS::Config::ConfigRule</code> indicates that the control is implemented by Amazon Web
     *         Services Config, and <code>AWS::SecurityHub::SecurityControl</code> indicates implementation by Amazon
     *         Web Services Security Hub.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The identifier originally assigned by the Amazon Web Services service that implements the control. For example,
     * <code>CODEPIPELINE_DEPLOYMENT_COUNT_CHECK</code>.
     * </p>
     * 
     * @return The identifier originally assigned by the Amazon Web Services service that implements the control. For
     *         example, <code>CODEPIPELINE_DEPLOYMENT_COUNT_CHECK</code>.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplementationSummary)) {
            return false;
        }
        ImplementationSummary other = (ImplementationSummary) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImplementationSummary").add("Type", type()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImplementationSummary, T> g) {
        return obj -> g.apply((ImplementationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImplementationSummary> {
        /**
         * <p>
         * A string that represents the Amazon Web Services service that implements this control. For example, a value
         * of <code>AWS::Config::ConfigRule</code> indicates that the control is implemented by Amazon Web Services
         * Config, and <code>AWS::SecurityHub::SecurityControl</code> indicates implementation by Amazon Web Services
         * Security Hub.
         * </p>
         * 
         * @param type
         *        A string that represents the Amazon Web Services service that implements this control. For example, a
         *        value of <code>AWS::Config::ConfigRule</code> indicates that the control is implemented by Amazon Web
         *        Services Config, and <code>AWS::SecurityHub::SecurityControl</code> indicates implementation by Amazon
         *        Web Services Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The identifier originally assigned by the Amazon Web Services service that implements the control. For
         * example, <code>CODEPIPELINE_DEPLOYMENT_COUNT_CHECK</code>.
         * </p>
         * 
         * @param identifier
         *        The identifier originally assigned by the Amazon Web Services service that implements the control. For
         *        example, <code>CODEPIPELINE_DEPLOYMENT_COUNT_CHECK</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ImplementationSummary model) {
            type(model.type);
            identifier(model.identifier);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public ImplementationSummary build() {
            return new ImplementationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
