/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the details of a mapping relationship, which can be either to a framework or to a common
 * control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mapping implements SdkPojo, Serializable, ToCopyableBuilder<Mapping.Builder, Mapping> {
    private static final SdkField<FrameworkMappingDetails> FRAMEWORK_FIELD = SdkField
            .<FrameworkMappingDetails> builder(MarshallingType.SDK_POJO).memberName("Framework")
            .getter(getter(Mapping::framework)).setter(setter(Builder::framework)).constructor(FrameworkMappingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<CommonControlMappingDetails> COMMON_CONTROL_FIELD = SdkField
            .<CommonControlMappingDetails> builder(MarshallingType.SDK_POJO).memberName("CommonControl")
            .getter(getter(Mapping::commonControl)).setter(setter(Builder::commonControl))
            .constructor(CommonControlMappingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControl").build()).build();

    private static final SdkField<RelatedControlMappingDetails> RELATED_CONTROL_FIELD = SdkField
            .<RelatedControlMappingDetails> builder(MarshallingType.SDK_POJO).memberName("RelatedControl")
            .getter(getter(Mapping::relatedControl)).setter(setter(Builder::relatedControl))
            .constructor(RelatedControlMappingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_FIELD,
            COMMON_CONTROL_FIELD, RELATED_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FrameworkMappingDetails framework;

    private final CommonControlMappingDetails commonControl;

    private final RelatedControlMappingDetails relatedControl;

    private final Type type;

    private Mapping(BuilderImpl builder) {
        this.framework = builder.framework;
        this.commonControl = builder.commonControl;
        this.relatedControl = builder.relatedControl;
        this.type = builder.type;
    }

    /**
     * <p>
     * The framework mapping details when the mapping type relates to a compliance framework.
     * </p>
     * 
     * @return The framework mapping details when the mapping type relates to a compliance framework.
     */
    public final FrameworkMappingDetails framework() {
        return framework;
    }

    /**
     * <p>
     * The common control mapping details when the mapping type relates to a common control.
     * </p>
     * 
     * @return The common control mapping details when the mapping type relates to a common control.
     */
    public final CommonControlMappingDetails commonControl() {
        return commonControl;
    }

    /**
     * <p>
     * Returns information about controls that are related to the specified control.
     * </p>
     * 
     * @return Returns information about controls that are related to the specified control.
     */
    public final RelatedControlMappingDetails relatedControl() {
        return relatedControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(commonControl());
        hashCode = 31 * hashCode + Objects.hashCode(relatedControl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping) obj;
        return Objects.equals(framework(), other.framework()) && Objects.equals(commonControl(), other.commonControl())
                && Objects.equals(relatedControl(), other.relatedControl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mapping").add("Framework", framework()).add("CommonControl", commonControl())
                .add("RelatedControl", relatedControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "CommonControl":
            return Optional.ofNullable(clazz.cast(commonControl()));
        case "RelatedControl":
            return Optional.ofNullable(clazz.cast(relatedControl()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #framework()} initialized to the given value.
     *
     * <p>
     * The framework mapping details when the mapping type relates to a compliance framework.
     * </p>
     * 
     * @param framework
     *        The framework mapping details when the mapping type relates to a compliance framework.
     */
    public static Mapping fromFramework(FrameworkMappingDetails framework) {
        return builder().framework(framework).build();
    }

    /**
     * Create an instance of this class with {@link #framework()} initialized to the given value.
     *
     * <p>
     * The framework mapping details when the mapping type relates to a compliance framework.
     * </p>
     * 
     * @param framework
     *        The framework mapping details when the mapping type relates to a compliance framework.
     */
    public static Mapping fromFramework(Consumer<FrameworkMappingDetails.Builder> framework) {
        FrameworkMappingDetails.Builder builder = FrameworkMappingDetails.builder();
        framework.accept(builder);
        return fromFramework(builder.build());
    }

    /**
     * Create an instance of this class with {@link #commonControl()} initialized to the given value.
     *
     * <p>
     * The common control mapping details when the mapping type relates to a common control.
     * </p>
     * 
     * @param commonControl
     *        The common control mapping details when the mapping type relates to a common control.
     */
    public static Mapping fromCommonControl(CommonControlMappingDetails commonControl) {
        return builder().commonControl(commonControl).build();
    }

    /**
     * Create an instance of this class with {@link #commonControl()} initialized to the given value.
     *
     * <p>
     * The common control mapping details when the mapping type relates to a common control.
     * </p>
     * 
     * @param commonControl
     *        The common control mapping details when the mapping type relates to a common control.
     */
    public static Mapping fromCommonControl(Consumer<CommonControlMappingDetails.Builder> commonControl) {
        CommonControlMappingDetails.Builder builder = CommonControlMappingDetails.builder();
        commonControl.accept(builder);
        return fromCommonControl(builder.build());
    }

    /**
     * Create an instance of this class with {@link #relatedControl()} initialized to the given value.
     *
     * <p>
     * Returns information about controls that are related to the specified control.
     * </p>
     * 
     * @param relatedControl
     *        Returns information about controls that are related to the specified control.
     */
    public static Mapping fromRelatedControl(RelatedControlMappingDetails relatedControl) {
        return builder().relatedControl(relatedControl).build();
    }

    /**
     * Create an instance of this class with {@link #relatedControl()} initialized to the given value.
     *
     * <p>
     * Returns information about controls that are related to the specified control.
     * </p>
     * 
     * @param relatedControl
     *        Returns information about controls that are related to the specified control.
     */
    public static Mapping fromRelatedControl(Consumer<RelatedControlMappingDetails.Builder> relatedControl) {
        RelatedControlMappingDetails.Builder builder = RelatedControlMappingDetails.builder();
        relatedControl.accept(builder);
        return fromRelatedControl(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Framework", FRAMEWORK_FIELD);
        map.put("CommonControl", COMMON_CONTROL_FIELD);
        map.put("RelatedControl", RELATED_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mapping, T> g) {
        return obj -> g.apply((Mapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mapping> {
        /**
         * <p>
         * The framework mapping details when the mapping type relates to a compliance framework.
         * </p>
         * 
         * @param framework
         *        The framework mapping details when the mapping type relates to a compliance framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(FrameworkMappingDetails framework);

        /**
         * <p>
         * The framework mapping details when the mapping type relates to a compliance framework.
         * </p>
         * This is a convenience method that creates an instance of the {@link FrameworkMappingDetails.Builder} avoiding
         * the need to create one manually via {@link FrameworkMappingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrameworkMappingDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #framework(FrameworkMappingDetails)}.
         * 
         * @param framework
         *        a consumer that will call methods on {@link FrameworkMappingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #framework(FrameworkMappingDetails)
         */
        default Builder framework(Consumer<FrameworkMappingDetails.Builder> framework) {
            return framework(FrameworkMappingDetails.builder().applyMutation(framework).build());
        }

        /**
         * <p>
         * The common control mapping details when the mapping type relates to a common control.
         * </p>
         * 
         * @param commonControl
         *        The common control mapping details when the mapping type relates to a common control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonControl(CommonControlMappingDetails commonControl);

        /**
         * <p>
         * The common control mapping details when the mapping type relates to a common control.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommonControlMappingDetails.Builder}
         * avoiding the need to create one manually via {@link CommonControlMappingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommonControlMappingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #commonControl(CommonControlMappingDetails)}.
         * 
         * @param commonControl
         *        a consumer that will call methods on {@link CommonControlMappingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commonControl(CommonControlMappingDetails)
         */
        default Builder commonControl(Consumer<CommonControlMappingDetails.Builder> commonControl) {
            return commonControl(CommonControlMappingDetails.builder().applyMutation(commonControl).build());
        }

        /**
         * <p>
         * Returns information about controls that are related to the specified control.
         * </p>
         * 
         * @param relatedControl
         *        Returns information about controls that are related to the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedControl(RelatedControlMappingDetails relatedControl);

        /**
         * <p>
         * Returns information about controls that are related to the specified control.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedControlMappingDetails.Builder}
         * avoiding the need to create one manually via {@link RelatedControlMappingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedControlMappingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedControl(RelatedControlMappingDetails)}.
         * 
         * @param relatedControl
         *        a consumer that will call methods on {@link RelatedControlMappingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedControl(RelatedControlMappingDetails)
         */
        default Builder relatedControl(Consumer<RelatedControlMappingDetails.Builder> relatedControl) {
            return relatedControl(RelatedControlMappingDetails.builder().applyMutation(relatedControl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FrameworkMappingDetails framework;

        private CommonControlMappingDetails commonControl;

        private RelatedControlMappingDetails relatedControl;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Mapping model) {
            framework(model.framework);
            commonControl(model.commonControl);
            relatedControl(model.relatedControl);
        }

        public final FrameworkMappingDetails.Builder getFramework() {
            return framework != null ? framework.toBuilder() : null;
        }

        public final void setFramework(FrameworkMappingDetails.BuilderImpl framework) {
            Object oldValue = this.framework;
            this.framework = framework != null ? framework.build() : null;
            handleUnionValueChange(Type.FRAMEWORK, oldValue, this.framework);
        }

        @Override
        public final Builder framework(FrameworkMappingDetails framework) {
            Object oldValue = this.framework;
            this.framework = framework;
            handleUnionValueChange(Type.FRAMEWORK, oldValue, this.framework);
            return this;
        }

        public final CommonControlMappingDetails.Builder getCommonControl() {
            return commonControl != null ? commonControl.toBuilder() : null;
        }

        public final void setCommonControl(CommonControlMappingDetails.BuilderImpl commonControl) {
            Object oldValue = this.commonControl;
            this.commonControl = commonControl != null ? commonControl.build() : null;
            handleUnionValueChange(Type.COMMON_CONTROL, oldValue, this.commonControl);
        }

        @Override
        public final Builder commonControl(CommonControlMappingDetails commonControl) {
            Object oldValue = this.commonControl;
            this.commonControl = commonControl;
            handleUnionValueChange(Type.COMMON_CONTROL, oldValue, this.commonControl);
            return this;
        }

        public final RelatedControlMappingDetails.Builder getRelatedControl() {
            return relatedControl != null ? relatedControl.toBuilder() : null;
        }

        public final void setRelatedControl(RelatedControlMappingDetails.BuilderImpl relatedControl) {
            Object oldValue = this.relatedControl;
            this.relatedControl = relatedControl != null ? relatedControl.build() : null;
            handleUnionValueChange(Type.RELATED_CONTROL, oldValue, this.relatedControl);
        }

        @Override
        public final Builder relatedControl(RelatedControlMappingDetails relatedControl) {
            Object oldValue = this.relatedControl;
            this.relatedControl = relatedControl;
            handleUnionValueChange(Type.RELATED_CONTROL, oldValue, this.relatedControl);
            return this;
        }

        @Override
        public Mapping build() {
            return new Mapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Mapping#type()
     */
    public enum Type {
        FRAMEWORK,

        COMMON_CONTROL,

        RELATED_CONTROL,

        UNKNOWN_TO_SDK_VERSION
    }
}
