/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines filtering criteria for the ListControls operation. You can use this filter to narrow down
 * the list of controls based on their implementation details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlFilter implements SdkPojo, Serializable, ToCopyableBuilder<ControlFilter.Builder, ControlFilter> {
    private static final SdkField<ImplementationFilter> IMPLEMENTATIONS_FIELD = SdkField
            .<ImplementationFilter> builder(MarshallingType.SDK_POJO).memberName("Implementations")
            .getter(getter(ControlFilter::implementations)).setter(setter(Builder::implementations))
            .constructor(ImplementationFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Implementations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPLEMENTATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImplementationFilter implementations;

    private ControlFilter(BuilderImpl builder) {
        this.implementations = builder.implementations;
    }

    /**
     * <p>
     * A filter that narrows the results to controls with specific implementation types or identifiers. This field
     * allows you to find controls that are implemented by specific Amazon Web Services services or with specific
     * service identifiers.
     * </p>
     * 
     * @return A filter that narrows the results to controls with specific implementation types or identifiers. This
     *         field allows you to find controls that are implemented by specific Amazon Web Services services or with
     *         specific service identifiers.
     */
    public final ImplementationFilter implementations() {
        return implementations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(implementations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlFilter)) {
            return false;
        }
        ControlFilter other = (ControlFilter) obj;
        return Objects.equals(implementations(), other.implementations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlFilter").add("Implementations", implementations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Implementations":
            return Optional.ofNullable(clazz.cast(implementations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Implementations", IMPLEMENTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlFilter, T> g) {
        return obj -> g.apply((ControlFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlFilter> {
        /**
         * <p>
         * A filter that narrows the results to controls with specific implementation types or identifiers. This field
         * allows you to find controls that are implemented by specific Amazon Web Services services or with specific
         * service identifiers.
         * </p>
         * 
         * @param implementations
         *        A filter that narrows the results to controls with specific implementation types or identifiers. This
         *        field allows you to find controls that are implemented by specific Amazon Web Services services or
         *        with specific service identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder implementations(ImplementationFilter implementations);

        /**
         * <p>
         * A filter that narrows the results to controls with specific implementation types or identifiers. This field
         * allows you to find controls that are implemented by specific Amazon Web Services services or with specific
         * service identifiers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImplementationFilter.Builder} avoiding
         * the need to create one manually via {@link ImplementationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImplementationFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #implementations(ImplementationFilter)}.
         * 
         * @param implementations
         *        a consumer that will call methods on {@link ImplementationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #implementations(ImplementationFilter)
         */
        default Builder implementations(Consumer<ImplementationFilter.Builder> implementations) {
            return implementations(ImplementationFilter.builder().applyMutation(implementations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImplementationFilter implementations;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlFilter model) {
            implementations(model.implementations);
        }

        public final ImplementationFilter.Builder getImplementations() {
            return implementations != null ? implementations.toBuilder() : null;
        }

        public final void setImplementations(ImplementationFilter.BuilderImpl implementations) {
            this.implementations = implementations != null ? implementations.build() : null;
        }

        @Override
        public final Builder implementations(ImplementationFilter implementations) {
            this.implementations = implementations;
            return this;
        }

        @Override
        public ControlFilter build() {
            return new ControlFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
