/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines filtering criteria for the ListControlMappings operation. You can use this filter to narrow
 * down the list of control mappings based on control ARNs, common control ARNs, or mapping types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlMappingFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlMappingFilter.Builder, ControlMappingFilter> {
    private static final SdkField<List<String>> CONTROL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ControlArns")
            .getter(getter(ControlMappingFilter::controlArns))
            .setter(setter(Builder::controlArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMMON_CONTROL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CommonControlArns")
            .getter(getter(ControlMappingFilter::commonControlArns))
            .setter(setter(Builder::commonControlArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControlArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MAPPING_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MappingTypes")
            .getter(getter(ControlMappingFilter::mappingTypesAsStrings))
            .setter(setter(Builder::mappingTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARNS_FIELD,
            COMMON_CONTROL_ARNS_FIELD, MAPPING_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> controlArns;

    private final List<String> commonControlArns;

    private final List<String> mappingTypes;

    private ControlMappingFilter(BuilderImpl builder) {
        this.controlArns = builder.controlArns;
        this.commonControlArns = builder.commonControlArns;
        this.mappingTypes = builder.mappingTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasControlArns() {
        return controlArns != null && !(controlArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of control ARNs to filter the mappings. When specified, only mappings associated with these controls are
     * returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlArns} method.
     * </p>
     * 
     * @return A list of control ARNs to filter the mappings. When specified, only mappings associated with these
     *         controls are returned.
     */
    public final List<String> controlArns() {
        return controlArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommonControlArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommonControlArns() {
        return commonControlArns != null && !(commonControlArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of common control ARNs to filter the mappings. When specified, only mappings associated with these common
     * controls are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommonControlArns} method.
     * </p>
     * 
     * @return A list of common control ARNs to filter the mappings. When specified, only mappings associated with these
     *         common controls are returned.
     */
    public final List<String> commonControlArns() {
        return commonControlArns;
    }

    /**
     * <p>
     * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappingTypes} method.
     * </p>
     * 
     * @return A list of mapping types to filter the mappings. When specified, only mappings of these types are
     *         returned.
     */
    public final List<MappingType> mappingTypes() {
        return MappingTypeFilterListCopier.copyStringToEnum(mappingTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MappingTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMappingTypes() {
        return mappingTypes != null && !(mappingTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappingTypes} method.
     * </p>
     * 
     * @return A list of mapping types to filter the mappings. When specified, only mappings of these types are
     *         returned.
     */
    public final List<String> mappingTypesAsStrings() {
        return mappingTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasControlArns() ? controlArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCommonControlArns() ? commonControlArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMappingTypes() ? mappingTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlMappingFilter)) {
            return false;
        }
        ControlMappingFilter other = (ControlMappingFilter) obj;
        return hasControlArns() == other.hasControlArns() && Objects.equals(controlArns(), other.controlArns())
                && hasCommonControlArns() == other.hasCommonControlArns()
                && Objects.equals(commonControlArns(), other.commonControlArns()) && hasMappingTypes() == other.hasMappingTypes()
                && Objects.equals(mappingTypesAsStrings(), other.mappingTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlMappingFilter").add("ControlArns", hasControlArns() ? controlArns() : null)
                .add("CommonControlArns", hasCommonControlArns() ? commonControlArns() : null)
                .add("MappingTypes", hasMappingTypes() ? mappingTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlArns":
            return Optional.ofNullable(clazz.cast(controlArns()));
        case "CommonControlArns":
            return Optional.ofNullable(clazz.cast(commonControlArns()));
        case "MappingTypes":
            return Optional.ofNullable(clazz.cast(mappingTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlArns", CONTROL_ARNS_FIELD);
        map.put("CommonControlArns", COMMON_CONTROL_ARNS_FIELD);
        map.put("MappingTypes", MAPPING_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlMappingFilter, T> g) {
        return obj -> g.apply((ControlMappingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlMappingFilter> {
        /**
         * <p>
         * A list of control ARNs to filter the mappings. When specified, only mappings associated with these controls
         * are returned.
         * </p>
         * 
         * @param controlArns
         *        A list of control ARNs to filter the mappings. When specified, only mappings associated with these
         *        controls are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlArns(Collection<String> controlArns);

        /**
         * <p>
         * A list of control ARNs to filter the mappings. When specified, only mappings associated with these controls
         * are returned.
         * </p>
         * 
         * @param controlArns
         *        A list of control ARNs to filter the mappings. When specified, only mappings associated with these
         *        controls are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlArns(String... controlArns);

        /**
         * <p>
         * A list of common control ARNs to filter the mappings. When specified, only mappings associated with these
         * common controls are returned.
         * </p>
         * 
         * @param commonControlArns
         *        A list of common control ARNs to filter the mappings. When specified, only mappings associated with
         *        these common controls are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonControlArns(Collection<String> commonControlArns);

        /**
         * <p>
         * A list of common control ARNs to filter the mappings. When specified, only mappings associated with these
         * common controls are returned.
         * </p>
         * 
         * @param commonControlArns
         *        A list of common control ARNs to filter the mappings. When specified, only mappings associated with
         *        these common controls are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonControlArns(String... commonControlArns);

        /**
         * <p>
         * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
         * </p>
         * 
         * @param mappingTypes
         *        A list of mapping types to filter the mappings. When specified, only mappings of these types are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTypesWithStrings(Collection<String> mappingTypes);

        /**
         * <p>
         * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
         * </p>
         * 
         * @param mappingTypes
         *        A list of mapping types to filter the mappings. When specified, only mappings of these types are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTypesWithStrings(String... mappingTypes);

        /**
         * <p>
         * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
         * </p>
         * 
         * @param mappingTypes
         *        A list of mapping types to filter the mappings. When specified, only mappings of these types are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTypes(Collection<MappingType> mappingTypes);

        /**
         * <p>
         * A list of mapping types to filter the mappings. When specified, only mappings of these types are returned.
         * </p>
         * 
         * @param mappingTypes
         *        A list of mapping types to filter the mappings. When specified, only mappings of these types are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTypes(MappingType... mappingTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> controlArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> commonControlArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> mappingTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlMappingFilter model) {
            controlArns(model.controlArns);
            commonControlArns(model.commonControlArns);
            mappingTypesWithStrings(model.mappingTypes);
        }

        public final Collection<String> getControlArns() {
            if (controlArns instanceof SdkAutoConstructList) {
                return null;
            }
            return controlArns;
        }

        public final void setControlArns(Collection<String> controlArns) {
            this.controlArns = ControlArnFilterListCopier.copy(controlArns);
        }

        @Override
        public final Builder controlArns(Collection<String> controlArns) {
            this.controlArns = ControlArnFilterListCopier.copy(controlArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlArns(String... controlArns) {
            controlArns(Arrays.asList(controlArns));
            return this;
        }

        public final Collection<String> getCommonControlArns() {
            if (commonControlArns instanceof SdkAutoConstructList) {
                return null;
            }
            return commonControlArns;
        }

        public final void setCommonControlArns(Collection<String> commonControlArns) {
            this.commonControlArns = CommonControlArnFilterListCopier.copy(commonControlArns);
        }

        @Override
        public final Builder commonControlArns(Collection<String> commonControlArns) {
            this.commonControlArns = CommonControlArnFilterListCopier.copy(commonControlArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonControlArns(String... commonControlArns) {
            commonControlArns(Arrays.asList(commonControlArns));
            return this;
        }

        public final Collection<String> getMappingTypes() {
            if (mappingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return mappingTypes;
        }

        public final void setMappingTypes(Collection<String> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copy(mappingTypes);
        }

        @Override
        public final Builder mappingTypesWithStrings(Collection<String> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copy(mappingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingTypesWithStrings(String... mappingTypes) {
            mappingTypesWithStrings(Arrays.asList(mappingTypes));
            return this;
        }

        @Override
        public final Builder mappingTypes(Collection<MappingType> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copyEnumToString(mappingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingTypes(MappingType... mappingTypes) {
            mappingTypes(Arrays.asList(mappingTypes));
            return this;
        }

        @Override
        public ControlMappingFilter build() {
            return new ControlMappingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
