/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetControlRequest extends ControlCatalogRequest implements
        ToCopyableBuilder<GetControlRequest.Builder, GetControlRequest> {
    private static final SdkField<String> CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlArn").getter(getter(GetControlRequest::controlArn)).setter(setter(Builder::controlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String controlArn;

    private GetControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlArn = builder.controlArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control. It has one of the following formats:
     * </p>
     * <p>
     * <i>Global format</i>
     * </p>
     * <p>
     * <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code>
     * </p>
     * <p>
     * <i>Or Regional format</i>
     * </p>
     * <p>
     * <code>arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code>
     * </p>
     * <p>
     * Here is a more general pattern that covers Amazon Web Services Control Tower and Control Catalog ARNs:
     * </p>
     * <p>
     * <code>^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\-]+$</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control. It has one of the following formats:</p>
     *         <p>
     *         <i>Global format</i>
     *         </p>
     *         <p>
     *         <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code>
     *         </p>
     *         <p>
     *         <i>Or Regional format</i>
     *         </p>
     *         <p>
     *         <code>arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code>
     *         </p>
     *         <p>
     *         Here is a more general pattern that covers Amazon Web Services Control Tower and Control Catalog ARNs:
     *         </p>
     *         <p>
     *         <code>^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\-]+$</code>
     */
    public final String controlArn() {
        return controlArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetControlRequest)) {
            return false;
        }
        GetControlRequest other = (GetControlRequest) obj;
        return Objects.equals(controlArn(), other.controlArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetControlRequest").add("ControlArn", controlArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlArn":
            return Optional.ofNullable(clazz.cast(controlArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlArn", CONTROL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetControlRequest, T> g) {
        return obj -> g.apply((GetControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ControlCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetControlRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control. It has one of the following formats:
         * </p>
         * <p>
         * <i>Global format</i>
         * </p>
         * <p>
         * <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code>
         * </p>
         * <p>
         * <i>Or Regional format</i>
         * </p>
         * <p>
         * <code>arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code>
         * </p>
         * <p>
         * Here is a more general pattern that covers Amazon Web Services Control Tower and Control Catalog ARNs:
         * </p>
         * <p>
         * <code>^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\-]+$</code>
         * </p>
         * 
         * @param controlArn
         *        The Amazon Resource Name (ARN) of the control. It has one of the following formats:</p>
         *        <p>
         *        <i>Global format</i>
         *        </p>
         *        <p>
         *        <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code>
         *        </p>
         *        <p>
         *        <i>Or Regional format</i>
         *        </p>
         *        <p>
         *        <code>arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code>
         *        </p>
         *        <p>
         *        Here is a more general pattern that covers Amazon Web Services Control Tower and Control Catalog ARNs:
         *        </p>
         *        <p>
         *        <code>^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\-]+$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlArn(String controlArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ControlCatalogRequest.BuilderImpl implements Builder {
        private String controlArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetControlRequest model) {
            super(model);
            controlArn(model.controlArn);
        }

        public final String getControlArn() {
            return controlArn;
        }

        public final void setControlArn(String controlArn) {
            this.controlArn = controlArn;
        }

        @Override
        public final Builder controlArn(String controlArn) {
            this.controlArn = controlArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetControlRequest build() {
            return new GetControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
