/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional filter that narrows the list of objectives to a specific domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectiveFilter implements SdkPojo, Serializable, ToCopyableBuilder<ObjectiveFilter.Builder, ObjectiveFilter> {
    private static final SdkField<List<DomainResourceFilter>> DOMAINS_FIELD = SdkField
            .<List<DomainResourceFilter>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(ObjectiveFilter::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainResourceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainResourceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DomainResourceFilter> domains;

    private ObjectiveFilter(BuilderImpl builder) {
        this.domains = builder.domains;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain that's used as filter criteria.
     * </p>
     * <p>
     * You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
     * <code>ObjectiveFilter</code> isn’t supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return The domain that's used as filter criteria.</p>
     *         <p>
     *         You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
     *         <code>ObjectiveFilter</code> isn’t supported.
     */
    public final List<DomainResourceFilter> domains() {
        return domains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectiveFilter)) {
            return false;
        }
        ObjectiveFilter other = (ObjectiveFilter) obj;
        return hasDomains() == other.hasDomains() && Objects.equals(domains(), other.domains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectiveFilter").add("Domains", hasDomains() ? domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domains", DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectiveFilter, T> g) {
        return obj -> g.apply((ObjectiveFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectiveFilter> {
        /**
         * <p>
         * The domain that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
         * <code>ObjectiveFilter</code> isn’t supported.
         * </p>
         * 
         * @param domains
         *        The domain that's used as filter criteria.</p>
         *        <p>
         *        You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
         *        <code>ObjectiveFilter</code> isn’t supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<DomainResourceFilter> domains);

        /**
         * <p>
         * The domain that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
         * <code>ObjectiveFilter</code> isn’t supported.
         * </p>
         * 
         * @param domains
         *        The domain that's used as filter criteria.</p>
         *        <p>
         *        You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
         *        <code>ObjectiveFilter</code> isn’t supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(DomainResourceFilter... domains);

        /**
         * <p>
         * The domain that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the
         * <code>ObjectiveFilter</code> isn’t supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #domains(List<DomainResourceFilter>)}.
         * 
         * @param domains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(java.util.Collection<DomainResourceFilter>)
         */
        Builder domains(Consumer<DomainResourceFilter.Builder>... domains);
    }

    static final class BuilderImpl implements Builder {
        private List<DomainResourceFilter> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectiveFilter model) {
            domains(model.domains);
        }

        public final List<DomainResourceFilter.Builder> getDomains() {
            List<DomainResourceFilter.Builder> result = DomainResourceFilterListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainResourceFilter.BuilderImpl> domains) {
            this.domains = DomainResourceFilterListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainResourceFilter> domains) {
            this.domains = DomainResourceFilterListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainResourceFilter... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainResourceFilter.Builder>... domains) {
            domains(Stream.of(domains).map(c -> DomainResourceFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ObjectiveFilter build() {
            return new ObjectiveFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
